<?php
global $MAIN_FILE;
require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/item_type/xdbmigrate_itemtype_base.inc.php';

class xnppresentation extends xdbmigrate_itemtype_base {

  function __construct() {
    
  }
  
  /**
   * Initialize 
   */  
  public function init($db) {
    parent::init($db);
    $this->set_ng_item_name('Presentation');
    $this->add_file_mapping_array('presentation_file', 'presentation_file');
    $this->add_file_mapping_array('preview', 'preview');
    $this->add_file_mapping_array('readme', 'readme');
    $this->add_file_mapping_array('rights', 'rights');
    
    #Description migrate to ...
    $this->set_description('outline');
    
    #Duplicate Table
    $this->add_dup_table('xnppresentation_creator');
    $this->add_dup_table('xnppresentation_item_detail');
  }
  
  /**
   *
   * get xnppresentation_item_detail
   * 
   * @param int $item_id
   * @return Success:xnppresentation_item_detail Array includes fields, Fail:FALSE
   */
  protected function get_xnppresentation_item_detail($item_id){
    $tbl = get_WK_tbl('xnppresentation_item_detail');
    $sql = "select * from {$tbl} where presentation_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) == 1){
      return $result_array[0];
    }
    return FALSE;    
  }
  
  /**
   *
   * get get_xnppresentation_creator
   * 
   * @param int $item_id
   * @return Success:get_xnppresentation_creator Array includes fields, Fail:FALSE
   */ 
  protected function get_xnppresentation_creator($item_id){
    $tbl = get_WK_tbl('xnppresentation_creator');
    $sql = "select * from {$tbl} where presentation_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) > 0){
      return $result_array;
    }
    return FALSE;    
  }

  /**
   * Do migaration.
   * 
   * @param array $item xoonips_basic_item
   * @return Success:0,Fail:Negative number
   */ 
  public function migrate($item) {
    #xoonips_item
    $item_id = $item['item_id'];
    $item_detail = $this->get_xnppresentation_item_detail($item_id);
    if($item_detail === FALSE || $item_detail === null){
      return -errmsg(APP_MIGRATE, 'E1901',$item_id);
    }

    
    #presentation_type
    $result_array = $this->get_table_column_by_group('presentation_type');
    if($result_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1903');
    }
    $rc = $this->insert_any($result_array,$item_id,$item_detail['presentation_type']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1904',$item_id);
    }
    
    #readme
    $readme_array = $this->get_table_column_by_group('readme');
    if($readme_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1905');
    }
    $rc = $this->insert_any($readme_array,$item_id,$item_detail['readme']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1906',$item_id);
    }
    
    #rights
    $rights_array = $this->get_table_column_by_group('rights');
    if($rights_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1907');
    }
    $rights = $this->make_rights($item_detail);
    $rc = $this->insert_any($rights_array,$item_id,  $rights);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1908',$item_id);
    }
    
    #date
    $rc = $this->migrate_simple_date($item);
    if($rc < 0)return $rc;    
    
    #attachment_dl_limit
    $attdl_array = $this->get_table_column_by_item('attachment_dl_limit');
    if($attdl_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1909');
    }
    $rc = $this->insert_any($attdl_array,$item_id,$item_detail['attachment_dl_limit']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1910',$item_id);
    }
    
    #attachment_dl_notify
    $attnotify_array = $this->get_table_column_by_item('attachment_dl_notify');
    if($attnotify_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1911');
    }
    $rc = $this->insert_any($attnotify_array,$item_id,$item_detail['attachment_dl_notify']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1912',$item_id);
    }
    
    #experimenter
    $creators_array = $this->get_table_column_by_group('creators');
    if($creators_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1913');
    }
    $creator = $this->get_xnppresentation_creator($item_id);
    if($creator === FALSE){
      return -errmsg(APP_MIGRATE, 'E1902',$item_id);
    }
    
    foreach ($creator as $value) {
      $rc = $this->insert_any($creators_array,$item_id,$value['creator'],$value['creator_order']+1);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E1914',$item_id);
      }
    }
    return 0;
  }
}
