<?php

/**
 * XooNips Table Duplicate program.
 * 
 */
function usage($msg = NULL) {
  if(!is_null($msg)){
    fprintf(STDERR, "%s\n",$msg);
  }
  fprintf(STDERR,"Usage:migrate.php [-d][-D][-m mainfile.php] [-r run.log]\n");
  fprintf(STDERR,"Default mainfile is /var/www/html/mainfile.php\n");
  fprintf(STDERR,"-m:Specified mainfile.php.\n");
  fprintf(STDERR,"-d:Table maigration finished, then working table delete.\n");
  fprintf(STDERR,"-D:Working table ONLY delete.\n");
  fprintf(STDERR,"-r:Specified run.log.\n");
  exit(2);
}
function get_upload_dir($db,$tbl) {
    $sql = "select value from {$tbl} where name='upload_dir'";
    $result_array = $db->query($sql);
    if($result_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2801');
    }
    return $result_array[0]['value'];
  }

/**
  * mkdir top directory .
  * 
  */
function mkdir_top_dir($db) {
  $upload_dir = get_upload_dir($db,get_tbl('xoonips_config'));
  $upload_dir = $upload_dir."/item";
  if(file_exists($upload_dir)===FALSE){
    mkdir($upload_dir,0755);
    chown($upload_dir,"apache");
    chgrp($upload_dir,"apache");
  }
}

function  drop_wk_table($db){
  global $duptables;
  foreach ($duptables as $tbl) {
    $wktbl = get_WK_tbl($tbl);
    $sql = "drop table if exists {$wktbl}";
    if($db->exec($sql) === false) break;
  }
}

function drop_distinct_wk_table($db) {
    
  $wktbl = get_WK_tbl('xoonips_item_type');
  $sql = "select * from ".$wktbl;
  $wk_array = $db->query($sql); 
  foreach ($wk_array as $value) {
    $name = $value['name'];
    if(strcmp($name,'xoonips_index')==0){
      continue;
    }
    $fname = 'item_type/'.$name.'.inc.php';
    if(!file_exists($fname)){
      echo "Warning {$fname} not exist\n";
      continue;
    }
    require_once $fname;
  }
  foreach ($wk_array as $value) {
    $name = $value['name'];
    if(strcmp($name,'xoonips_index')==0){
      continue;
    }
    $classname = $value['name'];
    if(!class_exists($classname)){
      #return -3;
      continue;
    }
    $c = new $classname;
    $c->init($db);
    $arr = $c->get_dup_table();
    if(count($arr) == 0){
      return -5;
    }
    foreach ($arr as $tbl) {
      $wktbl = get_WK_tbl($tbl);
      $sql = "drop table if exists {$wktbl}";
      if($db->exec($sql) === false) break;      
    }
  }
}

function drop_wk_tables($db) {
    fprintf(STDERR, "Working table drop start.\n");
    drop_distinct_wk_table($db);
    drop_wk_table($db);
    fprintf(STDERR, "Working table droped.\n");
}

function migrate() {
  $rc = 0;
  $db = new migrate_db();
  if($db->connect() === FALSE){
    return -1;
  }
  $db->beginTransaction();
  global $DROPTABLE;
  global $DROPTABLEONLY;
  if($DROPTABLEONLY == true){
    drop_wk_tables($db);
    $db->commit();
    return true;
  }
  do{
    #Group
    fprintf(STDERR, "Groups Migrate Start.\n");
    mkdir_top_dir($db);
    $groups = new groups();
    $rc = $groups->migrate($db);
    if($rc < 0)break;
    fprintf(STDERR, "Groups Migrate Success.\n");
    
    #User -- Don't need migrate.
    fprintf(STDERR, "User Migrate Start.\n");
    set_status(APP_MIGRATE, XDBMIGRATE_MIGRATE_GROUP);
    $user = new users;
    $user->set_groups_obj($groups);
    $rc = $user->migrate($db);
    if($rc < 0)break;
    fprintf(STDERR, "User Migrate Success.\n");

    #Item
    set_status(APP_MIGRATE, XDBMIGRATE_MIGRATE_ITEM);
    fprintf(STDERR, "Item Migrate Start.\n");
    $item = new item;
    $rc = $item->migrate($db);
    if($rc < 0)break;
    fprintf(STDERR, "Item Migrate Success.\n");

    #search text
    set_status(APP_MIGRATE, XDBMIGRATE_MIGRATE_SEARCH_TEXT);
    fprintf(STDERR, "Search Text Migrate Start.\n");
    $search_text = new search_text();
    $search_text->init($db);
    $rc = $search_text->migrate();
    if($rc < 0)break;
    fprintf(STDERR, "Search Text Migrate Success.\n");

    #Index
    set_status(APP_MIGRATE, XDBMIGRATE_MIGRATE_INDEX);
    fprintf(STDERR, "Index Migrate Start.\n");
    $index = new index();
    $index->set_groups_obj($groups);
    $rc = $index->migrate($db);
    if($rc < 0)break;
    fprintf(STDERR, "Index Migrate Success.\n");
    
    #event_log
    set_status(APP_MIGRATE, XDBMIGRATE_MIGRATE_EVENT_LOG);
    fprintf(STDERR, "Event Log Migrate Start.\n");
    $event_log = new event_log();
    $event_log->set_groups_obj($groups);
    $rc = $event_log->migrate($db);
    if($rc < 0)break;
    fprintf(STDERR, "Event Log Migrate Success.\n");
   
    
    #OAI-PMH
    set_status(APP_MIGRATE, XDBMIGRATE_MIGRATE_OAI_PMH);
    fprintf(STDERR, "OAI-PMH Migrate Start.\n");
    $oai_pmh = new oai_pmh();
    $oai_pmh->init($db);
    $rc = $oai_pmh->migrate();
    switch ($rc) {
      case 0:
        fprintf(STDERR, "OAI-PMH Migrate Success.\n");
        break;
      case -1:
        fprintf(STDERR, "OAI-PMH Migrate Skip.\n");
        $rc = 0;
        break;
      default:
        break;
    }
    
    #notificateion
    set_status(APP_MIGRATE, XDBMIGRATE_MIGRATE_NOTIFICATION);
    fprintf(STDERR, "notificateion Migrate Start.\n");
    $notificateion = new notification();
    $notificateion->init($db);
    $rc = $notificateion->migrate();
    fprintf(STDERR, "notificateion Migrate Success.\n");
    
    #Drop WK tables
    if($DROPTABLE === true){
      drop_wk_tables($db);
    }
  }while(false);
  if($rc < 0){
    $db->rollBack();
    fprintf(STDERR, "Migrate fail.\n");
    return false;
  }
  $db->commit();
  fprintf(STDERR, "Migrate success!!\n");
  return true;
}

function get_cmd_path(){
  return XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/';
}

#
#MAIN
#

$MAIN_FILE = '/var/www/html/mainfile.php';
$RUN_LOG = null;
$DROPTABLE = false;
$DROPTABLEONLY = false;

$opts=getopt("r:m:dD");
if(array_key_exists('r', $opts)){
  $RUN_LOG = $opts['r'];
}
if(array_key_exists('m', $opts)){
  $MAIN_FILE = $opts['m'];
}
if(array_key_exists('d', $opts)){
  $DROPTABLE = true;
}

if(array_key_exists('D', $opts)){
  $DROPTABLEONLY = true;
}

if(!file_exists($MAIN_FILE)){
  usage("{$MAIN_FILE} does not exist.");
}
require_once $MAIN_FILE;
$cmddir = get_cmd_path();
require_once $cmddir.'inc/cmdlib.inc.php';
require_once $cmddir.'inc/migrate_db.inc.php';
require_once $cmddir.'inc/users.inc.php';
require_once $cmddir.'inc/item.inc.php';
require_once $cmddir.'inc/search_text.inc.php';
require_once $cmddir.'inc/index.inc.php';
require_once $cmddir.'inc/groups.inc.php';
require_once $cmddir.'inc/oai_pmh.inc.php';
require_once $cmddir.'inc/event_log.inc.php';
require_once $cmddir.'inc/notificateion.inc.php';
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/status.php';
set_status(APP_MIGRATE, XDBMIGRATE_START_MIGRATE);
migrate();
set_status(APP_MIGRATE, XDBMIGRATE_START_COMPLITE);
exit(0);
