<?php

/*
 * Port SearchAction.class.php
 */
if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOONIPS_MAIN_PATH.'/class/core/Item.class.php';

class model_search {
  
  private $itemTypeSearchConditionBean;
  private $dirname;
  private $trustDirname;
  private $uid;

  public function Init() {
    $this->dirname = $this->trustDirname = 'xoonips';
    $this->itemTypeSearchConditionBean = Xoonips_BeanFactory::getBean('ItemTypeSearchConditionBean', $this->dirname, $this->trustDirname);
  }
  
  public function set_uid($uid) {
    $this->uid = $uid;
  }

  private function get_item_type_name_to_condition_id($item_type_name) {
    $item_type = $this->itemTypeSearchConditionBean->selectByTitle($item_type_name);
    if (empty($item_type))
      return array();
    return $item_type[0]['condition_id'];
  }
  
  private function filter_user(&$iids) {
    $itemBean = Xoonips_BeanFactory::getBean('ItemVirtualBean', $this->dirname, $this->trustDirname);
    $itemBean->filterCanViewItem($iids, $this->uid);
  }

  public function doSearch($item_type_name,$keyword) {
    // fetch previous query conditions
    $iids = array();
    if (is_null($item_type_name)) {
      $search_condition = 1;
    } else {
      $search_condition = $this->get_item_type_name_to_condition_id($item_type_name);
      if (empty($search_condition)) {
        return $iids;
      }
    }
    if (trim($keyword) != '') {
      $itemFieldDetailBean = Xoonips_BeanFactory::getBean('ItemFieldDetailBean', $this->dirname, $this->trustDirname);
      $conDetailBean = Xoonips_BeanFactory::getBean('ItemTypeSearchConditionDetailBean', $this->dirname, $this->trustDirname);
      $conDetails = $conDetailBean->select($search_condition);
      if (count($conDetails) > 0) {
        $post_data = array();
        foreach ($conDetails as $conDetail) {
          $detailId = $conDetail['item_field_detail_id'];
          $itemtypeDetail = $itemFieldDetailBean->getItemTypeDetailById($detailId);
          if (!$itemtypeDetail)
            continue;
          $groupId = 0;
          $itemtypeId = $itemtypeDetail['item_type_id'];
          $post_data[$itemtypeId][$groupId.Xoonips_Enum::ITEM_ID_SEPARATOR.$itemtypeId.Xoonips_Enum::ITEM_ID_SEPARATOR.$detailId] = $keyword;
        }

        $searchSqlArr = array();
        foreach ($post_data as $key => $data) {
          if ($itemtypeId == 0)
            $key = 0;
          $item = new Xoonips_Item($key, $this->dirname, $this->trustDirname);
          $item->setDataFromPost($data);
          $searchSqlArr[] = $item->doSearch(Xoonips_Enum::OP_TYPE_QUICKSEARCH);
        }
        $searchSqlStr = implode(' UNION ALL ', $searchSqlArr);
        $sql = "SELECT DISTINCT item_id FROM ( $searchSqlStr ) AS temp";
        global $xoopsDB;
        $result = $xoopsDB->queryF($sql);
        if ($result) {
          while ($row = $xoopsDB->fetchArray($result)) {
            $iids[] = $row['item_id'];
          }
        }
        $this->filter_user($iids);
        return $iids;
      }
    }
    return $iids;
  }
}
