<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once USER_TRUST_PATH . "/class/AbstractDeleteAction.class.php";
require_once USER_TRUST_PATH . "/admin/forms/UserAdminDeleteForm.class.php";
require_once USER_TRUST_PATH . "/class/core/User.class.php";
require_once XOOPS_TRUST_PATH . "/libs/xoonips/class/core/BeanFactory.class.php";

class User_UserDeleteAction extends User_AbstractDeleteAction
{
	function _getId()
	{
		return xoops_getrequest('uid');
	}

	function &_getHandler()
	{
		$handler =& xoops_gethandler('user');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm = new User_UserAdminDeleteForm();
		$this->mActionForm->prepare();
	}
	
	function _setupObject()	
	{
		//
		// It is not possible to delete the super administrator.
		//
		parent::_setupObject();
		if (is_object($this->mObject) && $this->mObject->get('uid') == 1) {
			$this->mObject = null;
		}
	}

	function _doExecute()
	{
		XCube_DelegateUtils::call('Legacy.Admin.Event.UserDelete', new XCube_Ref($this->mObject));
		$handler =& xoops_gethandler('member');
		if ($handler->delete($this->mObject)) {
			XCube_DelegateUtils::call('Legacy.Admin.Event.UserDelete.Success', new XCube_Ref($this->mObject));
			return USER_FRAME_VIEW_SUCCESS;
		}
		else {
			XCube_DelegateUtils::call('Legacy.Admin.Event.UserDelete.Fail', new XCube_Ref($this->mObject));
			return USER_FRAME_VIEW_ERROR;
		}
	}
	
	function execute(&$controller, &$xoopsUser){
		if (xoops_getrequest('_form_control_cancel') != null) {
			return USER_FRAME_VIEW_CANCEL;
		}

		$render = $controller->mRoot->mContext->mModule->getRenderTarget();
		$userClass = User_User::getInstance();
		$uid = $this->_getId();
		$userClass->setId($uid);
		$message = '';
		if (!$userClass->deleteUserCheck($uid, $message)) {
			$render->setAttribute('errMsg', $message);
			return USER_FRAME_VIEW_ERROR;
		}

		if ($uid == $_SESSION['xoopsUserId']){
			$render->setAttribute('selfDel', true);
		}

		$userHandler =& xoops_gethandler('user');
		$user =& $userHandler->get($uid);
		if (!$userClass->deleteUser($uid)) {
			XCube_DelegateUtils::call('Legacy.Admin.Event.UserDelete.Fail', new XCube_Ref($user));
			return USER_FRAME_VIEW_ERROR; 
		} else {
			XCube_DelegateUtils::call('Legacy.Admin.Event.UserDelete.Success', new XCube_Ref($user));
		}
		return USER_FRAME_VIEW_SUCCESS;
		
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$user = User_User::getInstance();
		$user->setId($this->_getId());
		$render->setTemplateName('user_delete.html');
		$render->setAttribute('userView', $user->getDetailViewForCertify($this->_getId(),$_SESSION['xoopsUserId']));
		$render->setAttribute('uid', $this->_getId());
		$render->setAttribute('object', $this->mObject);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		if ($render->getAttribute('selfDel')){
			$controller->executeForward(XOOPS_URL."/user.php?op=logout");
		}else{
			$controller->executeForward("./index.php?action=UserList");
		}
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		if ($render->getAttribute('errMsg') != '') {
			$errorMsg = $render->getAttribute('errMsg');
		} else {
			$errorMsg = _MD_USER_ERROR_DBUPDATE_FAILED;
		}
		$controller->executeRedirect('./index.php?action=UserList', 1, $errorMsg);
	}
	
	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward('./index.php?action=UserList');
	}
}

?>
