<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once USER_TRUST_PATH . "/class/AbstractListAction.class.php";
require_once USER_TRUST_PATH . "/admin/forms/UserSearchFilterForm.class.php";
require_once USER_TRUST_PATH . "/class/core/User.class.php";
require_once XOOPS_TRUST_PATH . "/libs/xoonips/class/core/Errors.class.php";
class User_UserSearchListAction extends User_AbstractListAction
{
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('users_search');
		return $handler;
	}

	function &_getFilterForm()
	{
		$filter = new User_UserSearchFilterForm($this->_getPageNavi(), $this->_getHandler());
		return $filter;
	}
	
	function _getBaseUrl()
	{
		return "./index.php?action=UserSearchList";
	}
	
	function execute(&$controller, &$xoopsUser)
	{
		$user = User_User::getInstance();
		$errors = new Xoonips_Errors();
		$user->setDataFromPost($_POST);
		$user->searchCheck($errors);
		if (count($errors->getErrors()) != 0){
			
			$render = $controller->mRoot->mContext->mModule->getRenderTarget();
			$render->setTemplateName($this->dirname . '_search.html');
			$searchView = $user->getSearchViewWithDataForModerator();
			$render->setAttribute('searchView', $searchView);
			$render->setAttribute('error', $errors->getView($this->dirname));
			$render->setAttribute('dirname', $this->dirname);
		}else{
			return $this->getDefaultView($controller, $xoopsUser);
		}
		
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		$controller->mRoot->mDelegateManager->add('Legacy.Event.Explaceholder.Get.UserPagenaviOtherUrl',
'User_UserSearchListAction::renderOtherUrlControl');
		
		!isset($_POST['sortkey']) ? $sortkey = '' : $sortkey = $_POST['sortkey'];
		!isset($_POST['newOrder']) ? $order = '' : $order = $_POST['newOrder'];
		!isset($_GET['page']) ? $page = 1 : $page = $_GET['page'];
		$userslist = array();
		$user = User_User::getInstance();
		$user->setDataFromPost($_POST);
		$userslist = $user->doSearchForModerator();
		if (!$userslist){
			$userslist = array();
		}
		if ( !empty( $sortkey ) ){
			$sortlist = $this->getSortList($userslist,$sortkey);
			if ($order == "DESC"){
				array_multisort($sortlist, SORT_DESC, $userslist);
			}
			else{
				array_multisort($sortlist, $userslist);
			}
		}
		unset($_POST['sortkey']);
		unset($_POST['Id']);
		unset($_POST['newOrder']);
		$userId = $_SESSION['xoopsUserId'];
		$render->setAttribute('hiddenData', $_POST);
		$render->setTemplateName($this->dirname . '_search_list.html');
		$render->setAttribute('userList', $this->pageUserslist($userslist,$page,$this->perPage));
		$render->setAttribute('sortkey', $sortkey);
		$render->setAttribute('order', $order);
		$render->setAttribute('pagenavi', $this->pagenavi($userslist, 'index.php?action=UserSearchList&', $this->perPage));
		$render->setAttribute('page', $page);
		$render->setAttribute('pageNavi', $this->mFilter->mNavi);
		$render->setAttribute('userId', $userId);
		$render->setAttribute('dirname', $this->dirname);
	}

	private function getSortList($userslist,$sortkey){
		$sortlist = array();
		foreach($userslist as $row ){
			$sortlist[] = $row[$sortkey];
		}
		return $sortlist;
	}
	
	// set page size
	private $perPage = 20;
	
	/**
	 * Every page's url setting.
	 * 
	 * @return array
	 */
	private function pagenavi($list,$url,$perPage){
		$cnt = 1;
		$pageIndex = array();
		(int)$pageCount = count($list) / $perPage + 1;
		do{
			$page = $cnt;
			$pageIndex[$cnt] = "$url" . "page=$page";
			$cnt++;
		}while($cnt<$pageCount);
		return $pageIndex;
	}
	
	/**
	 * Every page's user information setting.
	 * 
	 * @return array
	 */
	private function pageUserslist($userslist,$page,$perPage){
		$pagelists = array_chunk($userslist,$perPage);
		$ret = array();
		$cnt = 1;
		foreach($pagelists as $list){
			if ($cnt == $page){
				$ret = $list;
				break;
			}
			$cnt++;
		}
		return $ret;
	}
}

?>
