<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once USER_TRUST_PATH . "/class/AbstractEditAction.class.php";
require_once USER_TRUST_PATH . "/admin/forms/UserValueSetAdminEditForm.class.php";
require_once XOOPS_TRUST_PATH . "/libs/xoonips/class/core/BeanFactory.class.php";

class User_UserValueSetEditAction extends User_AbstractEditAction
{		
	function _getSelectNameDb()
	{
		return urldecode(xoops_getrequest('select_name_db'));
	}
	
	function _getSelectNameInput()
	{		
		return  urldecode(xoops_getrequest('select_name_input'));
	}
	
	function _getId()
	{
		return xoops_getrequest('title_id');
	}

	function _getTitle()
	{
		return urldecode(xoops_getrequest('title'));
	}
	
	function _getSeqId()
	{
		return xoops_getrequest('seq_id');
	}
	
	function _getDisplay()
	{
		return xoops_getrequest('display');
	}
		
	//1:new mode,2:edit mode,3:add mode,4:delete mode
	function _getMode()
	{
		return xoops_getrequest('mode');
	}
	
	function _getOp()
	{
		return xoops_getrequest('op');
	}
	
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('user_field_value_set');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm = new User_UserValueSetAdminEditForm();
		$this->mActionForm->prepare();
	}
	
	function _setupObject()
	{	
		$this->mode = $this->_getMode();
		$select_name_input = addslashes($this->_getSelectNameInput());
		$this->mObjectHandler = $this->_getHandler();
		if ($this->mode == 2 || $this->mode == 5) {
			$this->mObject =& $this->mObjectHandler->get($select_name_input);
		}		
		if ($this->mObject == null) {
			$obj[] =& $this->mObjectHandler->create();
			$obj[0]->set('select_name', $select_name_input);
			$this->mObject = $obj;
		} elseif ($this->mode == 1) {
			$this->mActionForm->set('mode' , 2);
		}
	}

	function _doExecute(&$obj)
	{		
		$mode = $this->mActionForm->get('mode');	
		if ($mode == 1) {				
			return USER_FRAME_VIEW_INPUT;
		//update select name
		} elseif ($mode == 5) {
			$select_name_db = $this->mActionForm->get('select_name_db');
			$select_name_input = $this->mActionForm->get('select_name_input');

			$this->mObjectHandler = $this->_getHandler();
			
			if($select_name_db != $select_name_input){	
				$this->mObjectHandler->update($select_name_db, $select_name_input);
				$userDetailHandler =& xoops_getmodulehandler('user_field_detail');	
				$userDetailHandler->update($select_name_db, $select_name_input);
			}
		//update display order
		} elseif ($mode == 6) {
			$select_name_db = $this->mActionForm->get('select_name_db');
			$displays = $this->_getDisplay();
			$ids = $this->_getId();

			foreach ($ids as $key =>$id) {
				if($displays[$key]!= $key+1){
					$result = $this->mObjectHandler->updateWeight($id, $select_name_db, $key+1);
					if(!$result){
						return USER_FRAME_VIEW_ERROR;
					}
				}	
			}
		}
			
		$this->mode = $mode;
		return USER_FRAME_VIEW_SUCCESS;			
	}
		
    function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$userFieldValueSetBean = Xoonips_BeanFactory::getBean('UserFieldValueSetBean', $this->dirname, $this->trustDirname);

		$render->setTemplateName($this->dirname . '_value_set_edit.html');
		$render->setAttribute('actionForm', $this->mActionForm);
		$canIdEdit = array();
		foreach($this->mObject as $key=>$obj){
			if ($userFieldValueSetBean->checkUsedTitleId($obj->get('select_name'), $obj->get('title_id')) > 0) {
				$canIdEdit[$key] = false;
			} else {
				$canIdEdit[$key] = true;
			}
			$this->mObject[$key]->set('select_name', urlencode($obj->get('select_name')));
		}
		if ($this->mObject[0]->get('title_id') != '') {
			$render->setAttribute('object', $this->mObject);
			$render->setAttribute('canIdEdit', $canIdEdit);
		}
		$render->setAttribute('mode', $this->mode);
		$render->setAttribute('dirname', $this->dirname);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$mode = $this->mode;
		$select_name_input = urlencode($this->mActionForm->get('select_name_input'));
		if ($mode == 3) {
			$url = "./index.php?action=UserValueSetEdit&mode=2&select_name_input=$select_name_input";
			$controller->executeRedirect($url, 1, _AD_USER_MESSAGE_REGISTRY);
		} elseif ($mode == 2 || $mode == 5 || $mode == 6) {
			$url = "./index.php?action=UserValueSetEdit&mode=2&select_name_input=$select_name_input";
			$controller->executeRedirect($url, 1, _AD_USER_MESSAGE_UPDATE);
		} else {
			$url = "./index.php?action=UserValueSetEdit&mode=$mode&select_name_input=$select_name_input";
			$controller->executeForward($url);
		}
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$mode = $this->mode;
		$select_name_input = urlencode($this->mActionForm->get('select_name_input'));
		$url = "./index.php?action=UserValueSetEdit&mode=$mode&select_name_input=$select_name_input";
		$controller->executeRedirect($url, 1, _MD_USER_ERROR_DBUPDATE_FAILED);
	}
	
	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=UserValueSetList");
	}
}

?>
