<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/ViewTypeText.class.php';

class User_ViewTypeUserName extends Xoonips_ViewTypeText {

	public function setTemplate() {
		$this->template = $this->dirname . '_viewtype_username.html';
	}

	public function getEditViewForModerator($field, $value, $groupLoopId) {
   		$fieldName = $this->getFieldName($field, $groupLoopId);
		$this->getXoopsTpl()->assign('viewType', 'editForModeraot');
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('len', $field->getLen());
		$this->getXoopsTpl()->assign('value', $value);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	} 
	
	public function getEditView($field, $value, $groupLoopId) {
   		$fieldName = $this->getFieldName($field, $groupLoopId);
		$this->getXoopsTpl()->assign('viewType', 'edit');
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('value', $value);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}
	
	public function inputCheck(&$errors, $field, $value, $fieldName) {
		//dataCheck
		$field->getDataType()->inputCheck($errors, $field, $value, $fieldName);
		$myxoopsConfigUser = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF_USER);
		$parameters = array();
		$parameters[] = $field->getName();
		$value = trim($value);
		if ($value != '') {
			if ($this->unameIsExist($value)) {
				$errors->addError('_MD_USER_LANG_NICKNAMETAKEN', $fieldName, $parameters);
			} elseif (strlen($value) > $myxoopsConfigUser['maxuname']) {
				$parameters[] = $myxoopsConfigUser['maxuname'];
				$errors->addError('_MD_USER_ERROR_MAXLENGTH', $fieldName, $parameters);
			} elseif (strlen($value) < $myxoopsConfigUser['minuname']) {
				$parameters[] = $myxoopsConfigUser['minuname'];
				$errors->addError('_MD_USER_ERROR_MINLENGTH', $fieldName, $parameters);
			}
		} else {
			$parameters[] = $field->getName();
			$errors->addError('_MD_USER_ERROR_REQUIRED', $fieldName, $parameters);
		}	
	}
	
	public function editCheck(&$errors, $field, $value, $fieldName, $uid) {
		//dataCheck
		$field->getDataType()->inputCheck($errors, $field, $value, $fieldName);
		$myxoopsConfigUser = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF_USER);
		$parameters = array();
		$parameters[] = $field->getName();
		$value = trim($value);
		if ($value != '') {
			if ($this->unameIsExist($value) && $value != $this->getUname($uid)) {
				$errors->addError('_MD_USER_LANG_NICKNAMETAKEN', $fieldName, $parameters);
			} elseif (strlen($value) > $myxoopsConfigUser['maxuname']) {
				$parameters[] = $myxoopsConfigUser['maxuname'];
				$errors->addError('_MD_USER_ERROR_MAXLENGTH', $fieldName, $parameters);
			} elseif (strlen($value) < $myxoopsConfigUser['minuname']) {
				$parameters[] = $myxoopsConfigUser['minuname'];
				$errors->addError('_MD_USER_ERROR_MINLENGTH', $fieldName, $parameters);
			}
		} else {
			$parameters[] = $field->getName();
			$errors->addError('_MD_USER_ERROR_REQUIRED', $fieldName, $parameters);
		}
	}
	
	private function unameIsExist($value) {
		$ret = false;
		global $xoopsDB;
		$value = Xoonips_Utils::convertSQLStr($value);
		$sql = "select uname from " . $xoopsDB->prefix('users') . " where uname=" . $value;
		$result = $xoopsDB->queryF($sql);
		if ($row = $xoopsDB->fetchArray($result)) {
			$ret = true;
		}
		return $ret;
	}
	
	private function getUname($uid) {
		$ret = '';
		global $xoopsDB;
		$sql = "select uname from " . $xoopsDB->prefix('users') . " where uid=$uid";
		$result = $xoopsDB->queryF($sql);
		if ($row = $xoopsDB->fetchArray($result)) {
			$ret = $row['uname'];
		}
		return $ret;
	}
	
	public function mustCheck(&$errors, $field, $value, $fieldName) {
		return true;
	}
}
?>
