<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

class UserUser_field_value_setObject extends XoopsSimpleObject
{	
	function UserUser_field_value_setObject(){
		
		$this->initVar('select_name', XOBJ_DTYPE_STRING, '', true, 50);
		$this->initVar('title_id', XOBJ_DTYPE_STRING, '', false, 30);
		$this->initVar('title', XOBJ_DTYPE_STRING, '', true, 255);
		$this->initVar('weight', XOBJ_DTYPE_INT, 0, false);
	}
}

class UserUser_field_value_setHandler extends XoopsObjectGenericHandler
{
	var $mTable = 'user_field_value_set';
	var $mPrimary = 'select_name';
	var $mClass = 'UserUser_field_value_setObject';
	
	function &getObjects($criteria = null, $limit = null, $start = null, $id_as_key = false)
	{
		$ret = array();

		$sql = "SELECT DISTINCT select_name FROM " . $this->mTable;
		
		$limit = 0;
		$start = 0;

		if($criteria !== null && is_a($criteria, 'CriteriaElement')) {
			$where = $this->_makeCriteria4sql($criteria);
			
			if (trim($where)) {
				$sql .= " WHERE " . $where;
			}
			
			$sorts = array();
			foreach ($criteria->getSorts() as $sort) {
				$sorts[] = $sort['sort'] . ' ' . $sort['order'];
			}
			if ($criteria->getSort() != '') {
				$sql .= " ORDER BY " . implode(',', $sorts);
			}
			
			$limit=$criteria->getLimit();
			$start=$criteria->getStart();
		}
		
		$result = $this->db->query($sql, $limit, $start);
		if (!$result) {
			return $ret;
		}
		while($row = $this->db->fetchArray($result)) {
			$obj = new $this->mClass();
			$obj->assignVars($row);
			$obj->unsetNew();
			
			if ($id_as_key)	{
				$ret[$obj->get($this->mPrimary)] =& $obj;
			}
			else {
				$ret[]=&$obj;
			}
		
			unset($obj);
		}
	
		return $ret;
	}
	
	function getCount()
	{
        $sql = "SELECT COUNT(*) FROM ( select distinct select_name from " .$this->mTable . ")name"; 
		$result = $this->db->query( $sql );
		$count = $this->db->fetchRow($result);
		if ( $count[0] > 0 ){
			return $count[0];
		}
		return 0;
	}
	
	function &get($name)
	{
		$ret = array();
		$sql = "SELECT * FROM " . $this->mTable . " WHERE select_name ='${name}' ORDER BY weight,title_id";
		
		$result = $this->db->query($sql);
	
		if (!$result) {
			return $ret;
		}
		while($row = $this->db->fetchArray($result)) {
			$obj = new $this->mClass();
			$obj->assignVars($row);
			$obj->unsetNew();			
			$ret[]=&$obj;
		
			unset($obj);
		}
	
		return $ret;
	}
	
	function &getDetail($name,$id)
	{
		$criteria = new CriteriaCompo();
		$criteria->add(new Criteria('select_name', $name));
   		$criteria->add(new Criteria('title_id', $id));
		return parent::getObjects($criteria);
	}
	
	function delete(&$obj)
	{
		foreach($obj as $o){
			$criteria = new CriteriaCompo();
			$criteria->add(new Criteria('select_name', $o->get('select_name')));
			$criteria->add(new Criteria('title_id', $o->get('title_id')));
			$sql = "DELETE FROM " . $this->mTable . " WHERE " . $this->_makeCriteriaElement4sql($criteria, $o);
			return  $this->db->query($sql);
		}
		
	}
	
	function update($name,$newName)
	{
		$sql = "UPDATE " . $this->mTable . " set select_name ='${newName}' WHERE select_name ='${name}'";
		$result = $this->db->query($sql);
		if ( ! $result ) {
			return false;
			}
		return true;
	}
	
	function updateWeight($id,$name,$display)
	{
		$sql = "UPDATE ". $this->mTable ." set weight =". $display." WHERE select_name ='${name}' AND title_id ='${id}'";
		$result = $this->db->query($sql);
		if ( ! $result ) {
			return false;
		}		
		return true;
	}
}

?>

