<?php

include 'include/common.inc.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Request.class.php';

function imageError($err) {
	switch ($err) {
		case 403:
			header('HTTP/1.0 403 Forbidden');
			break;
		case 404:
			header('HTTP/1.0 404 Not Found');
			break;
		case 500:
			header('HTTP/1.0 500 Internal Server Error');
			break;
	}
	exit();
}

// get form data
$request = new Xoonips_Request();
$groupID = $request->getParameter('group_id');
if (empty($groupID)) {
	imageError(404);
}

// get file path
$file_path = XOOPS_ROOT_PATH . '/uploads/user/group/' . $groupID;
if (!is_readable($file_path )) {
	imageError(404);
}

list($width, $height, $mimeType, $attr) = getimagesize($file_path);
switch ($mimeType) {
	case IMAGETYPE_PNG:
		$imicon = imagecreatefrompng($file_path);
		break;
	case IMAGETYPE_GIF:
		$imicon = imagecreatefromgif($file_path);
		break;
	case IMAGETYPE_JPEG:
		$imicon = imagecreatefromjpeg($file_path);
		break;
	default:
		$imicon = null;
}
header('Content-Type: image/png');
imagepng($imicon);
imagedestroy($imicon);
exit();
?>
