<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

if(!defined('XLEPROGRESS_TRUST_PATH'))
{
	define('XLEPROGRESS_TRUST_PATH', XOOPS_TRUST_PATH . '/modules/xleprogress');
}

require_once XLEPROGRESS_TRUST_PATH . '/class/XleprogressUtils.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';
Xoonips_Utils::loadModinfoMessage('xleprogress');

//
// Define a basic manifesto.
//
$modversion['name'] = _MI_XLEPROGRESS_LANG_XLEPROGRESS;
$modversion['version'] = 0.01;
$modversion['description'] = _MI_XLEPROGRESS_DESC_XLEPROGRESS;
$modversion['author'] = _MI_XLEPROGRESS_LANG_AUTHOR;
$modversion['credits'] = _MI_XLEPROGRESS_LANG_CREDITS;
$modversion['help'] = 'help.html';
$modversion['license'] = 'GPL';
$modversion['official'] = 0;
$modversion['image'] = 'images/xleprogress.png';
$modversion['dirname'] = $myDirName;
$modversion['trust_dirname'] = 'xleprogress';

$modversion['cube_style'] = true;
$modversion['legacy_installer'] = array(
	'installer'   => array(
		'class' 	=> 'Installer',
		'namespace' => 'Xleprogress',
		'filepath'	=> XLEPROGRESS_TRUST_PATH . '/admin/class/installer/XleprogressInstaller.class.php'
	),
	'uninstaller' => array(
		'class' 	=> 'Uninstaller',
		'namespace' => 'Xleprogress',
		'filepath'	=> XLEPROGRESS_TRUST_PATH . '/admin/class/installer/XleprogressUninstaller.class.php'
	),
	'updater' => array(
		'class' 	=> 'Updater',
		'namespace' => 'Xleprogress',
		'filepath'	=> XLEPROGRESS_TRUST_PATH . '/admin/class/installer/XleprogressUpdater.class.php'
	)
);
$modversion['disable_legacy_2nd_installer'] = false;

$modversion['sqlfile']['mysql'] = 'sql/mysql.sql';
$modversion['tables'] = array(
	'{prefix}_{dirname}_type',
	'{prefix}_{dirname}_approval',
	'{prefix}_{dirname}_history',
	'{prefix}_{dirname}_item',
);

//
// Templates. You must never change [cubson] chunk to get the help of cubson.
//
$modversion['templates'] = array(
	array('file' => '{dirname}_approval_list.html','description' => _MI_XLEPROGRESS_TPL_APPROVAL_LIST),
	array('file' => '{dirname}_approval_edit.html','description' => _MI_XLEPROGRESS_TPL_APPROVAL_EDIT),
	array('file' => '{dirname}_approval_delete.html','description' => _MI_XLEPROGRESS_TPL_APPROVAL_DELETE),
	array('file' => '{dirname}_item_list.html','description' => _MI_XLEPROGRESS_TPL_ITEM_LIST),
	array('file' => '{dirname}_item_view.html','description' => _MI_XLEPROGRESS_TPL_ITEM_VIEW),
	array('file' => '{dirname}_history_list.html','description' => _MI_XLEPROGRESS_TPL_HISTORY_LIST),
	array('file' => '{dirname}_history_delete.html','description' => _MI_XLEPROGRESS_TPL_HISTORY_DELETE),
	array('file' => '{dirname}_history_edit.html','description' => _MI_XLEPROGRESS_TPL_HISTORY_EDIT),
	array('file' => '{dirname}_history_view.html','description' => _MI_XLEPROGRESS_TPL_HISTORY_VIEW),
	array('file' => '{dirname}_inc_menu.html','description' => 'menu'),
	array('file' => '{dirname}_style.css','description' => 'stylesheet for screen'),
);

//
// Admin panel setting
//
$modversion['hasAdmin'] = 1;
$modversion['adminindex'] = 'admin/index.php?action=Index';
$modversion['adminmenu'] = array();

//
// Public side control setting
//
$modversion['hasMain'] = 1;
$modversion['hasSearch'] = 0;
$modversion['sub'] = array();

//
// Config setting
//
$modversion['config'] = array(
	array(
		'name'			=> 'css_file',
		'title' 		=> '_MI_XLEPROGRESS_LANG_CSS_FILE',
		'description'	=> '_MI_XLEPROGRESS_DESC_CSS_FILE',
		'formtype'		=> 'textbox' ,
		'valuetype' 	=> 'text' ,
		'default'		=> '/modules/'.$myDirName.'/style.css',
		'options'		=> array()
	),
);

//
// Block setting
//
$modversion['blocks'] = array();

?>
