<?php

require_once dirname(dirname(dirname(__FILE__))) . '/class/core/ActionBase.class.php';
require_once XOOPS_ROOT_PATH . '/class/xoopsblock.php';

class Xoonips_PolicyItemPublicAction extends Xoonips_ActionBase {

	protected function doInit(&$request, &$response) {

		//title
		$title = _AM_XOONIPS_POLICY_ITEM_PUBLIC_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEM_PUBLIC_DESC;
		// breadcrumbs
		$breadcrumbs = array(
		  	array(
		    	'name' => _AM_XOONIPS_TITLE,
		    	'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/index.php',
		  	),
		  	array(
			    'name' => _AM_XOONIPS_POLICY_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy.php',
		  	),
		   	array(
			    'name' => _AM_XOONIPS_POLICY_ITEM_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_item.php'
		  	),
		  	array(
		   	 	'name' => $title,
		  	),
			);

		// token ticket
		$token_ticket = $this->createToken( $this->modulePrefix('admin_policy_item_public') );

		// get configs
		$config_keys = array(
			'certify_item' => 's',
			'download_file_compression' => 's',
		);
		$config_values = Xoonips_Utils::xoonipsAdminGetConfigs($config_keys, 'e', $this->dirname, $this->trustDirname);

		// >> certify item
		$certify_item = array();
		$ci['value'] = 'on';
		$ci['label'] = _AM_XOONIPS_POLICY_ITEM_PUBLIC_CERTIFY_ITEM_MANUAL;
		$ci['selected'] = ( $config_values['certify_item'] == 'on' ) ? 'yes' : 'no';
		$certify_item[] = $ci;
		$ci['value'] = 'auto';
		$ci['label'] = _AM_XOONIPS_POLICY_ITEM_PUBLIC_CERTIFY_ITEM_AUTO;
		$ci['selected'] = ( $config_values['certify_item'] == 'auto' ) ? 'yes' : 'no';
		$certify_item[] = $ci;

		// >> download file compression
		$download_file = array();
		$df['value'] = 'on';
		$df['label'] = _AM_XOONIPS_POLICY_ITEM_PUBLIC_DOWNLOAD_FILE_ZIP;
		$df['selected'] = ( $config_values['download_file_compression'] == 'on' ) ? 'yes' : 'no';
		$download_file[] = $df;
		$df['value'] = 'off';
		$df['label'] = _AM_XOONIPS_POLICY_ITEM_PUBLIC_DOWNLOAD_FILE_PLAIN;
		$df['selected'] = ( $config_values['download_file_compression'] == 'off' ) ? 'yes' : 'no';
		$download_file[] = $df;

		//get common viewdata
		$viewData = array();
		$viewData['token_ticket'] = $token_ticket;
		$viewData['download_file'] = $download_file;

		$viewData['certify_chk'] = (Xoonips_BeanFactory::chkXleprogress()) ? 1 : 0;

		$viewData['certify_item'] = $certify_item;
		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('init_success');

		return true;
	}

	protected function doUpdate(&$request, &$response) {

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_item_public') ) ) {
			$response->setSystemError('Ticket error');
			return false;
		}

		// get variables
		$post_keys = array(
		  	'certify_item' => array( 's', false, true, ),
		 	'download_file_compression' => array( 's', false, true, ),
		);
		$post_vals = Xoonips_Utils::xoonipsAdminGetRequests( 'post', $post_keys );

		// set config keys
		$config_keys = array();
		foreach ( $post_keys as $key => $attributes ) {
		    list( $data_type, $is_array, $required ) = $attributes;
		  	$config_keys[$key] = $data_type;
		}

		// update db values
		foreach ( $config_keys as $key => $type ) {
		  	Xoonips_Utils::xoonipsAdminSetConfig($key, $post_vals[$key], $type, $this->dirname, $this->trustDirname);
		}

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_item_public.php';
		$viewData['redirect_msg'] = _AM_XOONIPS_MSG_DBUPDATED;

		$response->setViewData($viewData);
		$response->setForward('update_success');

		return true;
	}
}
?>
