<?php

require_once dirname(dirname(dirname(__FILE__))) . '/class/core/ActionBase.class.php';
require_once XOOPS_ROOT_PATH . '/class/xoopsblock.php';

class Xoonips_PolicyUserAction extends Xoonips_ActionBase {

	protected function doInit(&$request, &$response) {

		//title
		$title = _AM_XOONIPS_POLICY_ACCOUNT_INITIAL_TITLE;
		$description = _AM_XOONIPS_POLICY_ACCOUNT_INITIAL_DESC;

		// breadcrumbs
		$breadcrumbs = array(
  		array(
    		'name' => _AM_XOONIPS_TITLE,
    		'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/index.php',
 	 	),
  		array(
    		'name' => _AM_XOONIPS_POLICY_TITLE,
    		'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy.php',
  		),
  		array(
    		'name' => _AM_XOONIPS_POLICY_ACCOUNT_TITLE,
    		'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_user_menu.php',
  		),
  		array(
    		'name' => $title,
  		),
		);

		// token ticket
		$token_ticket = $this->createToken( $this->modulePrefix('admin_policy_account') );

		// get configs
		$initvals_config_keys = array(
	  		'private_item_number_limit' => array(
	    		'title' => _AM_XOONIPS_LABEL_ITEM_NUMBER_LIMIT,
	    		'desc' => _AM_XOONIPS_POLICY_ACCOUNT_INITIAL_MAX_ITEM_DESC,
	    		'type' => 'i',
	  		),
	  		'private_index_number_limit' => array(
	    		'title' => _AM_XOONIPS_LABEL_INDEX_NUMBER_LIMIT,
	    		'desc' => _AM_XOONIPS_POLICY_ACCOUNT_INITIAL_MAX_INDEX_DESC,
	    		'type' => 'i',
	  		),
	  		'private_item_storage_limit' => array(
	    		'title' => _AM_XOONIPS_LABEL_ITEM_STORAGE_LIMIT,
	    		'desc' => _AM_XOONIPS_POLICY_ACCOUNT_INITIAL_MAX_DISK_DESC,
	    		'type' => 'i',
	  		),
		);
		foreach ($initvals_config_keys as $key => $value) {
  			$config_keys[$key] = $value['type'];
		}
		$config_values = Xoonips_Utils::xoonipsAdminGetConfigs($config_keys, 'e', $this->dirname, $this->trustDirname);
		// >> initial values
		$initil_values = array();
		foreach ($initvals_config_keys as $name => $value) {
  			$iv = array();
  			$iv['title'] = $value['title'];
  			$iv['desc'] = $value['desc'];
  			$iv['name'] = $name;
  			if ($name == 'private_item_storage_limit' ) {
   				$iv['value'] = $config_values[$name] / 1024 / 1024;
  			} else {
    			$iv['value'] = $config_values[$name];
  			}
  			$initial_values[] = $iv;
		}

		//get common viewdata
		$viewData = array();
		$viewData['token_ticket'] = $token_ticket;
		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['title'] = $title;
		$viewData['initial_values'] = $initial_values;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('init_success');

		return true;
	}

	protected function doUpdate(&$request, &$response) {

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_account') ) ) {
			$response->setSystemError('Ticket error');
			return false;
		}

		// get variables
		$post_keys = array(
  			'private_item_number_limit' => array('i', false, true,),
  			'private_index_number_limit' => array('i', false, true,),
  			'private_item_storage_limit' => array('i', false, true,),
		);

		$post_vals = Xoonips_Utils::xoonipsAdminGetRequests('post', $post_keys);
		$post_vals['private_item_storage_limit'] = (int) ($post_vals['private_item_storage_limit'] * 1024 * 1024);

		// set config keys
		$config_keys = array();
		foreach ($post_keys as $key => $attributes) {
  			list($data_type, $is_array, $required) = $attributes;
			$config_keys[$key] = $data_type;
		}

		// update db values
		foreach ($config_keys as $key => $type) {
			Xoonips_Utils::xoonipsAdminSetConfig($key, $post_vals[$key], $type, $this->dirname, $this->trustDirname);
		}

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_user.php';
		$viewData['redirect_msg'] = _AM_XOONIPS_MSG_DBUPDATED;

		$response->setViewData($viewData);
		$response->setForward('update_success');
		return true;
	}
}
?>
