<?php

require_once dirname(dirname(dirname(__FILE__))) . '/class/core/ActionBase.class.php';

class Xoonips_SystemMessageSignAction extends Xoonips_ActionBase {

	protected function doInit(&$request, &$response) {

		// title
		$title = _AM_XOONIPS_SYSTEM_MSGSIGN_TITLE;
		$description = _AM_XOONIPS_SYSTEM_MSGSIGN_DESC;

		// breadcrumbs
		$breadcrumbs = array(
		array(
		    'name' => _AM_XOONIPS_TITLE,
		    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/index.php',
		),
		array(
		    'name' => _AM_XOONIPS_SYSTEM_TITLE,
		    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/system.php',
		),
		array(
		    'name' => $title,
		),
		);

		// token ticket		
		$token_ticket = $this->createToken( $this->modulePrefix('admin_system_msgsign') );

		//get msgsign values
		$config_keys = array('message_sign' => 's');
		$config_values = Xoonips_Utils::xoonipsAdminGetConfigs($config_keys, 'e', $this->dirname, $this->trustDirname);
		
		// get common viewdata
		$viewData = array();
		
		$viewData['token_ticket'] = $token_ticket;
		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['title'] = $title;
		$viewData['config_values'] = $config_values;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('init_success');		
		return true;
	}

	protected function doUpdate(&$request, &$response) {

		// check token ticket		
		if (!$this->validateToken($this->modulePrefix('admin_system_msgsign'))) {
			$response->setSystemError('Ticket error');
			return false;
		}

		// get requests
		$post_keys = array('message_sign' => array('s', false, true));
		$post_vals = Xoonips_Utils::xoonipsAdminGetRequests('post', $post_keys);

		// set config keys
		$config_keys = array();
		foreach ($post_keys as $key => $attributes) {
			list($data_type, $is_array, $required) = $attributes;
			$config_keys[$key] = $data_type;
		}
		// update db values
		foreach ($config_keys as $key => $type) {
			Xoonips_Utils::xoonipsAdminSetConfig($key, $post_vals[$key], $type, $this->dirname, $this->trustDirname);
		}

		$this->notification->createMsgSign(true);

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/system_message_sign.php';
		$viewData['redirect_msg'] = _AM_XOONIPS_MSG_DBUPDATED;
		
		$response->setViewData($viewData);
		$response->setForward('update_success');
		return true;
	}
}
?>
