<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

// xoonips itemtypes block
function b_xoonips_itemtypes_show($options) {
	global $xoopsUser;

	$dirname = empty($options[0]) ? 'xoonips' : $options[0];
   	$module_handler =& xoops_gethandler('module');
	$module =& $module_handler->getByDirname($dirname);
	if (!is_object($module)) {
		exit('Access Denied');
	}
	$trustDirname = $module->getVar('trust_dirname');

	// hide block if user is guest and public index viewing policy is 'platform'
	if (!is_object($xoopsUser)) {
		$configBean = Xoonips_BeanFactory::getBean('ConfigBean', $dirname, $trustDirname);
		$target_user = $configBean->getConfig('public_item_target_user');
		if ($target_user != 'all') {
			// 'platform'
			return false;
		}
	}

	require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Request.class.php';
	require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Response.class.php';
	require_once dirname(dirname(__FILE__)) . '/class/action/ItemTypeAction.class.php';

	// get installed itemtypes
	$block = array();
	$request = new Xoonips_Request();
	$response = new Xoonips_Response();
	$op = $request->getParameter('op');
	if ($op == null) {
		$op = 'init';
	}
	$action = new Xoonips_ItemTypeAction($dirname);
	$action->doAction($request, $response);

	return $response->getViewData();
}
?>
