<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';

/**
 * @brief operate config table 
 *
 */
class Xoonips_ConfigBean extends Xoonips_BeanBase {
	
	private $configs = null;
	/**
	 * Constructor
	 **/
	public function Xoonips_ConfigBean($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('config', true);
		$sql = "SELECT * FROM $this->table";
		$result = $this->execute($sql);
		if (!$result) {
			return;
		}
		while ($row = $this->fetchArray($result)) {
			$this->configs[$row['name']] = $row['value'];
		}
		$this->freeRecordSet($result);
	}
	
	/**
	 * get config
	 * 
	 * @param
	 * @return string
	 */	
	public function getConfig($name) {
		$ret = null;
		if (isset($this->configs[$name])) {
			$ret = $this->configs[$name];
		}
		return $ret;
	}

	/**
	 * update config
	 * 
	 * @param
	 * @return boolean
	 */	
	public function updateConfig($name, $value) {
		$sql = "UPDATE $this->table SET value=" . Xoonips_Utils::convertSQLStr($value);
		$sql .= ' WHERE name=' . Xoonips_Utils::convertSQLStr($name);
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}		
		$this->configs[$name] = $value;
		return true;
	}
	
	/**
	 * insert config
	 * 
	 * @param
	 * @return boolean
	 */	
	public function insertConfig($name, $value) {
		$sql = "INSERT INTO $this->table (name,value) VALUES(" . Xoonips_Utils::convertSQLStr($name);
		$sql .= ',' . Xoonips_Utils::convertSQLStr($value) . ')';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}		
		$this->configs[$name] = $value;
		return true;
	}
	
	/**
	 * delete config
	 * 
	 * @param
	 * @return boolean
	 */	
	public function deleteConfig($name) {
		$sql = "DELETE FROM $this->table";
		$sql .= ' WHERE name=' . Xoonips_Utils::convertSQLStr($name);
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}		
		$this->configs[$name] = $value;
		return true;
	}
}
?>
