<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';

/**
 * @brief operate xoonips_item_field_value_set table
 *
 */
class Xoonips_ItemFieldValueSetBean extends Xoonips_BeanBase {

	/**
	 * Constructor
	 **/
	public function Xoonips_ItemFieldValueSetBean($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('item_field_value_set', true);
	}

	/**
	 *
	 * get item type select names
	 *
	 * @param
	 * @return itemtype select_name
	 */
	public function getSelectNames() {
		$sql = 'SELECT DISTINCT select_name FROM ' . $this->table . ' ORDER BY select_name';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$ret = array();
		while ($row = $this->fetchArray($result)) {
			$ret[] =& $row['select_name'];
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 *
	 * update item type weight
	 *
	 * @param int $id:id
	 *         int $num:weight
	 * @return bool true:success,false:failed
	 */
	public function updateItemTypeWeight($id, $name, $num) {
		$sql = "UPDATE $this->table set weight=$num WHERE title_id=" . Xoonips_Utils::convertSQLStr($id);
		$sql .= ' and select_name=' . Xoonips_Utils::convertSQLStr($name);
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 * update select_name
	 *
	 * @param var $oldname:oldname
	 *         var $newname:newname
	 * @return bool true:success,false:failed
	 */
	public function updateSelectName($oldname, $newname) {
		$sql = "UPDATE $this->table SET select_name=" . Xoonips_Utils::convertSQLStr($newname);
		$sql .= ' WHERE select_name=' . Xoonips_Utils::convertSQLStr($oldname);
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 * update select_name_detail
	 *
	 * @param var $oldname:oldname
	 *         var $newname:newnam
	 * @return itemtype select_name_detail
	 */
	public function updateSelectNameDetail($oldname, $newname) {
		$tbldetail = $this->prefix($this->modulePrefix('item_field_detail'));
		$sql = "UPDATE $this->table SET list=" . Xoonips_Utils::convertSQLStr($newname);
		$sql .= ' WHERE list=' . Xoonips_Utils::convertSQLStr($oldname);
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 *
	 * get item type select names
	 *
	 * @param var $valueName:select name
	 * @return array itemtype select_name
	 */
	public function getValueDetail($valueName) {
		$sql = "SELECT * FROM $this->table";
		$sql .= ' WHERE select_name=' . Xoonips_Utils::convertSQLStr($valueName);
		$sql .= ' ORDER BY weight';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$ret = array();
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 *
	 * delete item field values
	 *
	 * @param  var $id:title_id
	 * @param  var $name:select_name
	 * @return bool true:success,false:failed
	 */
	public function deleteItemsValue($id, $name) {
		$ret = true;
		$sql = "DELETE FROM $this->table";
		$sql .= ' WHERE title_id =' . Xoonips_Utils::convertSQLStr($id);
		$sql .= ' AND select_name =' . Xoonips_Utils::convertSQLStr($name);
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}

		return $ret;
	}

	/**
	 *
	 * get the title of the valuename
	 *
	 * @param  var  $valueName:select name
	 * @return bool true:success,false:failed
	 */
	public function getItemTypeValueCount($valueName) {
		$ret = true;
		$sql = "SELECT title FROM $this->table";
		$sql .= ' WHERE select_name =' . Xoonips_Utils::convertSQLStr($valueName);
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$ret = array();
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return  $ret;
	}

	/**
	 *
	 * check the newname
	 *
	 * @param  var $newname:newname
	 * @return  array select_name
	 */
	public function checkSelectNames($newname) {
		$sql = "SELECT select_name FROM $this->table";
		$sql .= ' WHERE select_name=' . Xoonips_Utils::convertSQLStr($newname);
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$ret = array();
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return  $ret;
	}

	/**
	 *
	 * get Info id
	 *
	 * @param  int $id:title_id
	 * @param  int $name:select_name
	 * @return  array id
	 */
	public function getInfo($id, $name) {
		$sql = 'SELECT * FROM ' . $this->table . " WHERE title_id='$id' AND select_name='$name'";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$row = $this->fetchArray($result);

		$this->freeRecordSet($result);
		return $row;
	}

	/**
	 *
	 * get valu name
	 *
	 * @param  var $name:select_name
	 * @return  array valuename
	 */
	public function getValue($name) {
		$sql = 'SELECT * FROM ' . $this->table . " WHERE select_name='$name'";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$row = $this->fetchArray($result);

		$this->freeRecordSet($result);
		return $row;
	}

	/**
	 *
	 * check title
	 *
	 * @param  var $name:name
	 *          var $title:title
	 * @return  boolean
	 */
	public function checkTitle($name, $title) {
		$sql = 'SELECT count(select_name) ac cnt FROM ' . $this->table
			. ' WHERE select_name='	. Xoonips_Utils::convertSQLStr($name)
			. ' and title=' . Xoonips_Utils::convertSQLStr($title);
   		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$ret = $this->fetchArray($result);

		$this->freeRecordSet($result);
		return $ret['cnt'];
	}
	
	/**
	 * check id
	 * 
	 * @param  var $name:selectname
	 *         var $title_id:id
	 * @return array
	 */
	public function checkTitleId($name, $title_id) {
		$sql = "SELECT count(select_name) as cnt FROM $this->table WHERE select_name=" . Xoonips_Utils::convertSQLStr($name)
			. " and title_id=" . Xoonips_Utils::convertSQLStr($title_id);
   		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$ret = $this->fetchArray($result);

		$this->freeRecordSet($result);
		return $ret['cnt'];
	}

	/**
	 * check id
	 * 
	 * @param  var $name:selectname
	 *         var $title_id:id
	 * @return array
	 */
	public function checkUsedTitleId($name, $title_id) {
		$itemTypeBean = Xoonips_BeanFactory::getBean('ItemTypeBean', $this->dirname, $this->trustDirname);
		$itemTypeList = $itemTypeBean->getItemTypeList();
		$itemBean = Xoonips_BeanFactory::getBean('ItemVirtualBean', $this->dirname, $this->trustDirname);
		$cnt = 0;
		foreach ($itemTypeList as $itemType) {
			$itemFieldManager = Xoonips_ItemFieldManagerFactory::getInstance($this->dirname, $this->trustDirname)->getItemFieldManager($itemType['item_type_id']);
	    	foreach ($itemFieldManager->getFields() as $field) {
	    		if ($field->getListId() == $name) {
	    			$cnt = $cnt + $itemBean->getCountUsedFieldValue(
	    					$field->getTableName(), $field->getColumnName(), $title_id);
	    		}
	    	}
		}
		return $cnt;
	}

	/**
	 *
	 * get max
	 *
	 * @param  var $name:name
	 *          var $col:col
	 * @return
	 */
	public function getMax($name, $col) {
		$sql = "SELECT MAX(CONVERT($col,UNSIGNED)) FROM " . $this->table . " WHERE select_name='$name'";
		$result = $this->execute($sql);
		$max = $this->fetchRow($result);
		if ($max[0] > 0) {
			return $max[0];
		}
		return 0;
	}

	/**
	 *
	 * insert value
	 *
	 * @param  var $value:value
	 * @return  boolean
	 */
	public function insertValue($value) {
		$ret = true;
		$sql = "INSERT INTO $this->table (select_name,title_id,title,weight)";
		$sql = $sql . ' VALUES(' . Xoonips_Utils::convertSQLStr($value['select_name']) . ',' . Xoonips_Utils::convertSQLStr($value['title_id']);
		$sql = $sql . ',' . Xoonips_Utils::convertSQLStr($value['title']). ',' . Xoonips_Utils::convertSQLNum($value['weight']). ')';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return $ret;
	}

	/**
	 *
	 * update value
	 *
	 * @param  var $value:value
	 * @return  boolean
	 */
	public function updateValue($value) {
		$ret = true;
		$sql = "UPDATE $this->table set title=" . Xoonips_Utils::convertSQLStr($value['title']);
		$sql .= ', title_id=' . Xoonips_Utils::convertSQLStr($value['title_id']);
		$sql .= ' WHERE title_id =' . Xoonips_Utils::convertSQLStr($value['title_id_db']). ' AND select_name =' . Xoonips_Utils::convertSQLStr($value['select_name']);
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return $ret;
	}

	/**
	 *
	 * get the title of the name
	 *
	 * @param  $selectName, $id
	 * @return bool true:success,false:failed
	 */
	public function getItemTypeValueTitle($selectName, $id) {
		$ret = true;
		$sql = "SELECT title FROM $this->table WHERE select_name ='$selectName' AND title_id='$id'";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$ret = '';
		while ($row = $this->fetchArray($result)) {
			$ret = $row['title'];
		}
		$this->freeRecordSet($result);
		return  $ret;
	}
}
?>
