<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';
/**
 * @brief operate xoonips_item_type_sort_detail table
 *
 */
class Xoonips_ItemTypeSortDetailBean extends Xoonips_BeanBase {

	/**
	 * Constructor
	 **/
	public function Xoonips_ItemTypeSortDetailBean($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('item_type_sort_detail', true);
	}

	/**
	 * select item sort detail
	 *
	 * @param $sort_id sort_id
	 * @return array
	 */
	public function select($sort_id) {
		$ret = array();
		$sql = 'SELECT * FROM ' . $this->table . " WHERE sort_id=$sort_id";
		$result = $this->execute($sql);
		if (!$result) {
			return $ret;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * insert
	 *
	 * @param  int $sort_id:sort_id
	 * @param  int $item_type_id:item_type_id
	 * @param  int $detail_id:detail_id
	 * @return int
	 */
	public function insert($sort_id, $item_type_id, $detail_id) {
		$ret = true;
		$sql = 'INSERT INTO '. $this->table . '(sort_id, item_type_id, item_field_detail_id)
			VALUES (' . $sort_id . ',' . $item_type_id . ','. $detail_id . ')';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return $ret;
	}

	/**
	 * delete by id
	 *
	 * @param  int $sort_id:sort_id
	 * @return  bool true:success,false:failed
	 */
	public function delete($sort_id) {

		$sql = "DELETE FROM $this->table WHERE sort_id=$sort_id";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 * delete by itemtype
	 *
	 * @param  int $itemtype_id:item_type_id
	 * @return  bool true:success,false:failed
	 */
	public function deleteByItemtypeId($itemtype_id) {
		$item_field_detail = $this->prefix($this->modulePrefix('item_field_detail'));
		$sql = "DELETE FROM $this->table WHERE item_field_detail_id in"
			. ' (select a.item_field_detail_id from ' . $item_field_detail . ' a'
			. ' where a.item_type_id=' . $itemtype_id . ')';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}
}
?>
