<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/ViewType.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/File.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Request.class.php';

class Xoonips_ViewTypeFileUpload extends Xoonips_ViewType {

	public function setTemplate() {
		$this->template = $this->dirname . '_viewtype_fileupload.html';
	}

	public function getInputView($field, $value, $groupLoopId) {
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$fileName = $fieldName . '_file';
		if ($this->isLayered()) {
			$fileId = 'none';
		} else {
			$file = new Xoonips_File($this->dirname, $this->trustDirname, true);
			$fileId = $file->uploadFile($fileName, 'upload', 0, $field->getId());
		}
		$fileBean = Xoonips_BeanFactory::getBean('ItemFileBean', $this->dirname, $this->trustDirname);
		if (!empty($value)) {
			if ($fileId == 'none') {
				$fileId = $value;
			} else {
				$fileBean->delete($value);
			}
		}
		$fileInfo = $fileBean->getFileInformation($fileId);
		$this->getXoopsTpl()->assign('viewType', 'input');
		$this->getXoopsTpl()->assign('fileName', $fileName);
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('value', $value);
		$this->getXoopsTpl()->assign('fileId', $fileId);
		$this->getXoopsTpl()->assign('fileInfo', $fileInfo);
		$this->getXoopsTpl()->assign('dirname', $this->dirname);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	public function fileUpload($field, $value, $groupLoopId) {
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$fileName = $fieldName . '_file';
		if (empty($value)) {
			$file = new Xoonips_File($this->dirname, $this->trustDirname, true);

			$fileId = $file->uploadFile($fileName, 'upload', 0, $field->getId(), $field->getFieldGroupId());

		} else {
			$fileId = $value;
		}
		$this->getXoopsTpl()->assign('viewType', 'fileUpload');
		$this->getXoopsTpl()->assign('fileName', $fileName);
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('value', $value);
		$this->getXoopsTpl()->assign('fileId', $fileId);
		$this->getXoopsTpl()->assign('dirname', $this->dirname);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	public function getDisplayView($field, $value, $groupLoopId) {
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$fileName = $fieldName . '_file';

		if ($this->isLayered()) {
			$fileId = 'none';
		} else {
			$file = new Xoonips_File($this->dirname, $this->trustDirname, true);
			$fileId = $file->uploadFile($fileName, 'upload', 0, $field->getId());
		}
		$fileBean = Xoonips_BeanFactory::getBean('ItemFileBean', $this->dirname, $this->trustDirname);
		if (!empty($value)) {
			if ($fileId == 'none') {
				$fileId = $value;
			} else {
				$fileBean->delete($value);
			}
		}
		$fileInfo = $fileBean->getFileInformation($fileId);
		$this->getXoopsTpl()->assign('viewType', 'confirm');
		$this->getXoopsTpl()->assign('fileName', $fileName);
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('value', $value);
		$this->getXoopsTpl()->assign('fileId', $fileId);
		$this->getXoopsTpl()->assign('fileInfo', $fileInfo);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	public function getEditView($field, $value, $groupLoopId) {
		return $this->getInputView($field, $value, $groupLoopId);
	}

	public function getDetailDisplayView($field, $value, $display) {
		if (!empty($value)) {
			$fileBean = Xoonips_BeanFactory::getBean('ItemFileBean', $this->dirname, $this->trustDirname);
			$fileInfo = $fileBean->getFileInformation($value);
			$file = $fileBean->getFile($value);
			if ($file !== false) {
				$itemBean = Xoonips_BeanFactory::getBean('ItemVirtualBean', $this->dirname, $this->trustDirname);
				$notify = $itemBean->getDownloadNotify($file['item_id'], $field->getItemTypeId());
				$rights = $itemBean->getRights($file['item_id'], $field->getItemTypeId());
				$limit = $itemBean->getDownloadLimit($file['item_id'], $field->getItemTypeId());
			}
			global $xoopsUser;
			$uid = is_object($xoopsUser) ? $xoopsUser->getVar('uid') : XOONIPS_UID_GUEST;
			$newFileInfo = array();
			foreach ($fileInfo as $file) {
				if ($file === false || ($rights === false && ($notify === false || $notify == '0'))) {
					$file['notify'] = false;
				} else {
					$file['notify'] = true;
				}
				if ($file === false || ($uid == XOONIPS_UID_GUEST && $limit === false)) {
					$file['limit'] = false;
				} else {
					$file['limit'] = true;
				}
				$newFileInfo[] = $file;
			}
			$fileInfo = $newFileInfo;
			$this->getXoopsTpl()->assign('fileInfo', $fileInfo);
		} else {
			$this->getXoopsTpl()->assign('fileInfo', '');
		}
		$this->getXoopsTpl()->assign('viewType', 'detail');
		$this->getXoopsTpl()->assign('fileId', $value);
		$this->getXoopsTpl()->assign('display', $display);
		$this->getXoopsTpl()->assign('dirname', $this->dirname);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	public function getSearchView($field, $groupLoopId) {
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$this->getXoopsTpl()->assign('viewType', 'search');
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	public function isDisplay($op) {
		if ($op == Xoonips_Enum::OP_TYPE_METAINFO) return false;//hidden when metainfo form
		return true;
	}

	public function mustCheck(&$errors, $field, $value, $fieldName) {
		if ($field->getEssential() == 1 && $value == '') {
			$fileName = $fieldName . '_file';
			$request = new Xoonips_Request();
			$file = $request->getFile($fileName);
			if (empty($file)) {
				$parameters = array();
				$parameters[] = $field->getName();
				$errors->addError('_MD_XOONIPS_ERROR_REQUIRED', $fieldName, $parameters);
			}
		}
	}

	public function inputCheck(&$errors, $field, $value, $fieldName) {
		$fileName = $fieldName . '_file';
		$request = new Xoonips_Request();
		$file = $request->getFile($fileName);
		if (empty($file)) return true;
		// storage limit check
		global $xoopsUser;
		$uid = $xoopsUser->getVar('uid');
		$itemBean = Xoonips_BeanFactory::getBean('ItemVirtualBean', $this->dirname, $this->trustDirname);
		$privateItemLimit = $itemBean->getPrivateItemLimit($uid);
		$filesizes = $itemBean->getFilesizePrivate($uid);
		if ($filesizes > $privateItemLimit['itemStorage'] && $privateItemLimit['itemStorage'] > 0) {
			$parameters = array();
			$parameters[] = '';
			$errors->addError('_MD_XOONIPS_ITEM_WARNING_ITEM_STORAGE_LIMIT', '', $parameters);
		}
	}

	public function doRegistry($field, &$data, &$sqlStrings, $groupLoopId) {
		$tableName = $field->getTableName();
		$columnName = $this->getData($field, $data, $groupLoopId);
		$tableData;
		$columnData;
		if (isset($sqlStrings[$tableName])) {
			$tableData = &$sqlStrings[$tableName];
		} else {
			$tableData = array();
			$sqlStrings[$tableName] = &$tableData;
		}

		if (isset($tableData[$columnName])) {
			$columnData = &$tableData[$columnName];
		} else {
			$columnData = array();
			$tableData[$columnName] = &$columnData;
		}
		$columnData[0] = $field->getDataType()->convertSQLStr('');
		$columnData[1] = $field->getId();
	}

	public function doSearch($field, &$data, &$sqlStrings, $groupLoopId, $scopeSearchFlg, $isExact) {
		$tableName = $field->getTableName();
		$columnName = $field->getColumnName();
		$value = $data[$this->getFieldName($field, $groupLoopId)];

		if (isset($sqlStrings[$tableName])) {
			$tableData = &$sqlStrings[$tableName];
		} else {
			$tableData = array();
			$sqlStrings[$tableName] = &$tableData;
		}
		if ($value != '') {
			$encoding = mb_detect_encoding($value);
			$query1 = $this->search->getSearchSql('original_file_name', $value, $field->getDataType(), $isExact);
			$query2 = $this->search->getFulltextSearchSql('search_text', $value, $encoding);
			if ($query2 != '') {
				$tableData[] = '(' . $query1 . ' OR ' . $query2 . ')';
			} else {
				$tableData[] = $query1;
			}
		}
	}

	public function getMetadata($field, &$data) {
		$table = $field->getTableName();
		$column = $field->getColumnName();
		$detail_id = $field->getId();
		$original_file_name = array();
		$mime_type = array();
		foreach ($data[$table] as $value) {
			if ($value['item_field_detail_id'] == $detail_id) {
				$original_file_name[] = $value['original_file_name'];
				$mime_type[] = $value['mime_type'];
			}
		}
		return array(implode(',', $original_file_name), implode(',', $mime_type));
	}
	/**
	 *
	 * get entity data
	 *
	 * @param object $field
	 * 		   array $data
	 * @return mix
	 */
	public function getEntitydata($field, &$data) {
		$table = $field->getTableName();
		$column = $field->getColumnName();
		$detail_id = $field->getId();
		$ret = array();
		$i = 0;
		foreach ($data[$table] as $value) {
			if ($value['item_field_detail_id'] == $detail_id) {
				$ret[$i]['original_file_name'] = $value['original_file_name'];
				$ret[$i]['mime_type'] = $value['mime_type'];
				$ret[$i]['file_size'] = $value['file_size'];
				$ret[$i]['handle_name'] = $value['handle_name'];
				$ret[$i]['caption'] = $value['caption'];
				$ret[$i]['download_count'] = $value['download_count'];
				$ret[$i]['thumbnail_file'] = $value['thumbnail_file'];
				$i++;
			}
		}
		return $ret;
	}

	/**
	 *
	 * get default value block view
	 *
	 * @param $list, $value, $disabled
	 * @return string
	 */
	public function getDefalutValueBlockView($list, $value, $disabled = '') {
		$this->getXoopsTpl()->assign('viewType', 'default');
		$this->getXoopsTpl()->assign('value', $value);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	/**
	 *
	 * must Create item_extend table
	 *
	 * @param
	 * @return boolean
	 */
	public function mustCreateItemExtendTable() {
		return false;
	}
}
?>
