<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/WorkflowBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';

class Xoonips_WorkflowPublicItemsWithdrawal extends Xoonips_WorkflowBase {

	public function doCertify($indexItemLinkId, &$result, $comment) {
		$result[0] = false;
		$indexItemLinkBean = null;
		$workflow = Xoonips_WorkflowFactory::getWorkflow('WorkflowPublicItems', $this->dirname, $this->trustDirname);
		list($itemId, $indexId) = $workflow->getItemAndIndexId($indexItemLinkId, $indexItemLinkBean);
		// delete xoonip_index_item_link info by index_id and item_id
		if ($itemId == 0 || !$indexItemLinkBean->deleteByid($indexId, $itemId)) {
			return false;
		}
		//update xoonips_oaipmh_item_status
		$openIndexIds = $indexItemLinkBean->getOpenIndexIds($itemId);
		if ($openIndexIds === false) return false;
		if (count($openIndexIds) == 0) {
			$itemStatusBean = Xoonips_BeanFactory::getBean('OaipmhItemStatusBean', $this->dirname, $this->trustDirname);
			if (!$itemStatusBean->delete($itemId)) {
				return false;
			}
		}
		$result[0] = true;
		//event log
		$this->log->recordCertifyItemWithdrawalEvent($itemId, $indexId);

		//send to item users
		$itemUsersBean = Xoonips_BeanFactory::getBean('ItemUsersLinkBean', $this->dirname, $this->trustDirname);
		$itemUsersInfo = $itemUsersBean->getItemUsersInfo($itemId);
		$sendToUsers = array();
		foreach ($itemUsersInfo as $itemUser) {
			$sendToUsers[$itemUser['uid']] = $itemUser['uid'];
		}
		XCube_DelegateUtils::call('Legacy_Workflow.GetAllCertifyUsers', Xoonips_Enum::certifyPublicItemsWithdrawal($this->dirname), new XCube_Ref($sendToUsers));
		$this->notification->itemPublicWithdrawal($itemId, $indexId, $sendToUsers, $comment);
	}

	public function doProgress($indexItemLinkId, &$result, $comment) {
		$result[0] = false;
		$indexItemLinkBean = null;
		$workflow = Xoonips_WorkflowFactory::getWorkflow('WorkflowPublicItems', $this->dirname, $this->trustDirname);
		list($itemId, $indexId) = $workflow->getItemAndIndexId($indexItemLinkId, $indexItemLinkBean);
		if ($itemId == 0) {
			return;
		}
		$sendToUsers = array();
		XCube_DelegateUtils::call('Legacy_Workflow.GetCurrentCertifyUsers', Xoonips_Enum::certifyPublicItemsWithdrawal($this->dirname), $indexItemLinkId, new XCube_Ref($sendToUsers));
		$this->notification->itemPublicWithdrawalRequest($itemId, $indexId, $sendToUsers);
		$result[0] = true;
	}

	public function doRefuse($indexItemLinkId, &$result, $comment) {
		$result[0] = false;
		$indexItemLinkBean = null;
		$workflow = Xoonips_WorkflowFactory::getWorkflow('WorkflowPublicItems', $this->dirname, $this->trustDirname);
		list($itemId, $indexId) = $workflow->getItemAndIndexId($indexItemLinkId, $indexItemLinkBean);
		// update xoonip_index_item_link
		if ($itemId == 0 || !$indexItemLinkBean->update($indexId, $itemId, 2)) {
			return false;
		}
		$result[0] = true;

		//event log
		$this->log->recordRejectItemWithdrawalEvent($itemId, $indexId);

		//send to item users
		$itemUsersBean = Xoonips_BeanFactory::getBean('ItemUsersLinkBean', $this->dirname, $this->trustDirname);
		$itemUsersInfo = $itemUsersBean->getItemUsersInfo($itemId);
		$sendToUsers = array();
		foreach ($itemUsersInfo as $itemUser) {
			$sendToUsers[$itemUser['uid']] = $itemUser['uid'];
		}
		XCube_DelegateUtils::call('Legacy_Workflow.GetAllCertifyUsers', Xoonips_Enum::certifyPublicItemsWithdrawal($this->dirname), new XCube_Ref($sendToUsers));
		$this->notification->itemPublicWithdrawalRejected($itemId, $indexId, $sendToUsers, $comment);		
	}

	public function getDetailView($indexItemLinkId) {
		$workflow = Xoonips_WorkflowFactory::getWorkflow('WorkflowPublicItems', $this->dirname, $this->trustDirname);
		return $workflow->getDetailView($indexItemLinkId);
	}
}
?>
