<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOONIPS_CONTROL_PATH.'control_base.php';
require_once XOONIPS_MAIN_PATH.'/class/XmlItemImport.class.php';

class itemreg extends control_base {

  private $lang;

  public function Init() {
    $root = &XCube_Root::getSingleton();
    $c = $root->mContext->getXoopsConfig();
    $this->lang = $c['language'];
  }
  
  public function run($req) {
    $key_arr = $req->get_file_keys();
    if (count($key_arr) == 0) {
      $this->rest_notify_err(400, 'Nothing requeset info');
    }
    
    $xml = $req->get_file_info('xml');
    if (empty ($xml)) {
      $this->rest_notify_err(400, 'XML not found');
    }
    $xmlfname = $xml['tmp_name'];
    $dblang = $this->get_db_lang();
    if (is_null($dblang)) {
      $this->rest_notify_err(500, 'DB language is not UTF-8 or EUC-JP.');
    }

    // XML parse and put db etc.
    $imp = new XmlItemImport();
    $imp->uid($this->uid);
    $imp->set_db_lang($dblang);
    $arr = $req->get_file_array();
    $imp->set_tmp_file_array($arr);
    $imp->xml_import_by_file($xmlfname);
    $item_id = $imp->get_create_item_id();
    // Make Result
    $res_code = $imp->get_err_code();
    switch ($res_code) {
    case 200:
      res_code($res_code, null, true);
      echo $this->mk_response_xml(0, $item_id);
      break;
    default:
      $line_no = $imp->get_line_no();
      $this->rest_notify_err($res_code, $imp->get_err_msg().' line:'.$line_no, $item_id);
      break;
    }
  }
}
