<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/ViewTypeRadioBox.class.php';

class User_ViewTypeEmailNotice extends Xoonips_ViewTypeRadioBox {

	public function getInputView($field, $value, $groupLoopId) {
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$radioName = $fieldName . '_radiobox';
		$this->getXoopsTpl()->assign('viewType', 'input');
		$this->getXoopsTpl()->assign('list', $this->getList());
		$this->getXoopsTpl()->assign('radioName', $radioName);
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('value', $value);
		$this->getXoopsTpl()->assign('dirname', $this->dirname);
		self::setTemplate();
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	public function getSearchInputView($field, $value, $groupLoopId) {
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$this->getXoopsTpl()->assign('viewType', 'search');
		$this->getXoopsTpl()->assign('list', $this->getList());
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('value', $value);
		self::setTemplate();
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	public function getEditViewForModerator($field, $value, $groupLoopId) {
		$fieldName = $this->getFieldName($field, $groupLoopId);
    	$radioName = $fieldName . '_radiobox';
		$this->getXoopsTpl()->assign('viewType', 'input');
		$this->getXoopsTpl()->assign('list', $this->getList());
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('radioName', $radioName);
		$this->getXoopsTpl()->assign('value', $value);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	public function getDisplayView($field, $value, $groupLoopId) {
		$ret = '';
		$list = $this->getList();
		if ($value !== '') {
			$ret = isset($list[$value]) ? $list[$value] : '';
		}
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$this->getXoopsTpl()->assign('viewType', 'confirm');
		$this->getXoopsTpl()->assign('valueName', $ret);
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('value', $value);
		self::setTemplate();
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	public function getDetailDisplayView($field, $value, $display) {
		$list = $this->getList();
		$this->getXoopsTpl()->assign('viewType', 'detail');
		$this->getXoopsTpl()->assign('valueName', $list[$value]);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	private function getList() {
		$ret = array();		
		$ret[1] = _YES;
		$ret[0] = _NO;
		return $ret;
	}
}

