<?php
require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/inc/migrate_db.inc.php';

class index {
  protected $db;
  private   $last_autoinc;
  private   $openlevel_to_certify_state = array(
                      #Key OpenLevel,Value Certify_State
                        1=>2, #private=>not share
                        2=>2, #group=>not share
                        3=>0  #public=>Share
                      );
  function __construct() {
    
  }
  
  /**
   * insert ng xoonips_index table
   * 
   * @param array $index_val include indexes 
   */
  protected function insert_ng_index($index_val) {
    $index_tbl = get_tbl('xoonips_index');
    $uid = $this->db->conv_0str($index_val['uid']);
    $gid = $this->db->conv_0str($index_val['gid']);
    $title = $this->db->quote($index_val['title']);
    if(strcasecmp($gid,'NULL')){
      $gid = "'".(string)(intval(str_replace("'", '', $gid)) + intval($this->last_autoinc))."'";
    }
    $sql = "insert into {$index_tbl} (index_id,parent_index_id,uid,groupid,open_level,weight,last_update_date,creation_date,title)".
          "VALUES ('{$index_val['item_id']}','{$index_val['parent_index_id']}',{$uid},{$gid},'{$index_val['open_level']}','{$index_val['sort_number']}','{$index_val['last_update_date']}','{$index_val['creation_date']}',{$title})";
    return $this->db->exec($sql);
  }
 
  /**
   * To get XooNIps 3.46a xoonips_index_item_link table.
   * 
   * @param int $index_id
   * @return mixed Success:Array,Fail:false
   */
  protected function get_index_item_link($index_id){
    $tbl = get_WK_tbl('xoonips_index_item_link');
    $sql = " select index_item_link_id,index_id,item_id,certify_state from {$tbl}".
           " where index_id = {$index_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) > 0){
      return $result_array;
    }
    return FALSE;   
  }

    
  /**
   * insert to xoonips_index_item_link
   * 
   * @param int $index_id
   * @param int $certify_state
   * @return Sucess:true,Fail:false
   */
  protected function migrate_item_link($index_id,$certify_state) {
    $result_array = $this->get_index_item_link($index_id);
    if($result_array === FALSE){
      return true;
    }
    $tbl = get_tbl('xoonips_index_item_link');
    foreach ($result_array as $value) {
      $sql = "insert into {$tbl} (index_id,item_id,certify_state)".
        "values('{$value['index_id']}','{$value['item_id']}','{$certify_state}')";
        if($this->db->exec($sql) === false)return false;
    }
    return true;
  }
  
  private function delete_index() {
    $tbl = get_tbl('xoonips_index');
    $sql = "delete from {$tbl}";
    $this->db->exec($sql);
  }
          

  /**
   * Set groups object
   * 
   * @param object $groups 
   */
  public function set_groups_obj(&$groups)
  {
    $this->last_autoinc = $groups->get_last_autoinc();
  }

  public function migrate() {
    $this->db = new migrate_db();
    if($this->db->connect() === FALSE){
      return -errmsg(APP_MIGRATE,'E1005');
    }
    
    #All Index data delete.
    $this->delete_index();
    
    # listing index
    $item_basic_tbl = get_WK_tbl('xoonips_item_basic');
    $item_type_tbl  = get_WK_tbl('xoonips_item_type');
    $item_title_tbl = get_WK_tbl('xoonips_item_title');
    $index_tbl      = get_WK_tbl('xoonips_index');
    $sql = 'select * '.
            'from '.$item_basic_tbl .' as item,'.
                    $item_type_tbl  .' as type,'.
                    $item_title_tbl .' as title,'.
                    $index_tbl      .' as index1'.
            ' where item.item_id =index1.index_id and'.
            ' item.item_id =title.item_id and'.
            ' item.item_type_id =type.item_type_id and'.
            " type.name = 'xoonips_index'";
    $wk_array = $this->db->query($sql);
    foreach ($wk_array as $index_val) {
      $rc = $this->insert_ng_index($index_val);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE,'E2601');
      }
      $certify = $this->openlevel_to_certify_state[$index_val['open_level']];
      $rc = $this->migrate_item_link($index_val['index_id'], $certify);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE,'E2602');
      }
    }
    return 0;
  }
}
