<?php

/**
 * XooNips Table Duplicate program.
 * 
 */
function usage($msg = NULL) {
  if(!is_null($msg)){
    fprintf(STDERR, "%s\n",$msg);
  }
  fprintf(STDERR,"Usage:migrate.php [-m mainfile.php] [-r run.log]\n");
  fprintf(STDERR,"Default maifile is /var/www/html/mainfile.php\n");
  exit(2);
}

function  drop_wk_table(){
  $db = new migrate_db();
  if($db->connect() === FALSE){
    return -errmsg(APP_MIGRATE,'E1005');
  }
  global $duptables;
  foreach ($duptables as $tbl) {
    $wktbl = get_WK_tbl($tbl);
    $sql = "drop table if exists {$wktbl}";
    if($db->exec($sql) === false) break;
  }
}

function drop_distinct_wk_table() {
  
  $db = new migrate_db();
  if($db->connect() === FALSE){
    return -errmsg(APP_MIGRATE,'E1005');
  }
  
  $wktbl = get_WK_tbl('xoonips_item_type');
  $sql = "select * from ".$wktbl;
  $wk_array = $db->query($sql); 
  foreach ($wk_array as $value) {
    $name = $value['name'];
    if(strcmp($name,'xoonips_index')==0){
      continue;
    }
    $fname = 'item_type/'.$name.'.inc.php';
    if(!file_exists($fname)){
      echo "Warning {$fname} not exist\n";
      continue;
    }
    require_once $fname;
  }
  foreach ($wk_array as $value) {
    $name = $value['name'];
    if(strcmp($name,'xoonips_index')==0){
      continue;
    }
    $classname = $value['name'];
    if(!class_exists($classname)){
      #return -3;
      continue;
    }
    $c = new $classname;
    $c->init();
    $arr = $c->get_dup_table();
    if(count($arr) == 0){
      return -5;
    }
    foreach ($arr as $tbl) {
      $wktbl = get_WK_tbl($tbl);
      $sql = "drop table if exists {$wktbl}";
      echo "$sql\n";
      if($db->exec($sql) === false) break;      
    }
  }
}

function migrate() {
  $rc = 0;
  global $DROPTABLE;
  do{
    #Group
    $groups = new groups();
    $rc = $groups->migrate();
    if($rc < 0)break;
    fprintf(STDERR, "Groups Migrate Success.\n");
    
    #User -- Don't need migrate.
    set_status(APP_MIGRATE, XDBMIGRATE_MIGRATE_GROUP);
    $user = new users;
    $user->set_groups_obj($groups);
    $rc = $user->migrate();
    if($rc < 0)break;
    fprintf(STDERR, "User Migrate Success.\n");

    #Item
    set_status(APP_MIGRATE, XDBMIGRATE_MIGRATE_ITEM);
    $item = new item;
    $rc = $item->migrate();
    if($rc < 0)break;
    fprintf(STDERR, "Item Migrate Success.\n");

    #search text
    set_status(APP_MIGRATE, XDBMIGRATE_MIGRATE_SEARCH_TEXT);
    $search_text = new search_text();
    $search_text->init();
    $rc = $search_text->migrate();
    if($rc < 0)break;
    fprintf(STDERR, "Search Text Migrate Success.\n");

    #Index
    set_status(APP_MIGRATE, XDBMIGRATE_MIGRATE_INDEX);
    $index = new index();
    $index->set_groups_obj($groups);
    $rc = $index->migrate();
    if($rc < 0)break;
    fprintf(STDERR, "Index Migrate Success.\n");
    
    #event_log
    set_status(APP_MIGRATE, XDBMIGRATE_MIGRATE_EVENT_LOG);
    $event_log = new event_log();
    $event_log->set_groups_obj($groups);
    $rc = $event_log->migrate();
    if($rc < 0)break;
    fprintf(STDERR, "Event Log Migrate Success.\n");
   
    
    #OAI-PMH
    set_status(APP_MIGRATE, XDBMIGRATE_MIGRATE_OAI_PMH);
    $oai_pmh = new oai_pmh();
    $oai_pmh->init();
    $rc = $oai_pmh->migrate();
    switch ($rc) {
      case 0:
        fprintf(STDERR, "OAI-PMH Migrate Success.\n");
        break;
      case -1:
        fprintf(STDERR, "OAI-PMH Migrate Skip.\n");
        $rc = 0;
        break;
      default:
        break;
    }
    
    #Drop WK tables
    if($DROPTABLE === true){
      drop_distinct_wk_table();
      drop_wk_table();
      fprintf(STDERR, "Working table droped.\n");
    }
  }while(false);
  if($rc < 0){
    fprintf(STDERR, "Migrate fail.\n");
    return false;
  }
  fprintf(STDERR, "Migrate success!!\n");
  return true;
}

function get_cmd_path(){
  return XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/';
}

#
#MAIN
#

$MAIN_FILE = '/var/www/html/mainfile.php';
$RUN_LOG = null;
$DROPTABLE = false;

$opts=getopt("r:m:d");
if(array_key_exists('r', $opts)){
  $RUN_LOG = $opts['r'];
}
if(array_key_exists('m', $opts)){
  $MAIN_FILE = $opts['m'];
}
if(array_key_exists('d', $opts)){
  $DROPTABLE = true;
}

if(!file_exists($MAIN_FILE)){
  usage("{$MAIN_FILE} does not exist.");
}
require_once $MAIN_FILE;
$cmddir = get_cmd_path();
require_once $cmddir.'inc/cmdlib.inc.php';
require_once $cmddir.'inc/migrate_db.inc.php';
require_once $cmddir.'inc/users.inc.php';
require_once $cmddir.'inc/item.inc.php';
require_once $cmddir.'inc/search_text.inc.php';
require_once $cmddir.'inc/index.inc.php';
require_once $cmddir.'inc/groups.inc.php';
require_once $cmddir.'inc/oai_pmh.inc.php';
require_once $cmddir.'inc/event_log.inc.php';
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/status.php';
set_status(APP_MIGRATE, XDBMIGRATE_START_MIGRATE);
migrate();
set_status(APP_MIGRATE, XDBMIGRATE_START_COMPLITE);
exit(0);
