<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';

// xoonips usermenu block
function b_xoonips_user_show($options) {
	global $xoopsUser;

	$dirname = empty($options[0]) ? 'xoonips' : $options[0];

	// hide block if user is guest
	if (!is_object($xoopsUser)) {
		return false;
	}

	$uid = $xoopsUser->getVar('uid');

	$block = array();

	// get xoonips module id
	$module_handler =& xoops_gethandler('module');
	$module =& $module_handler->getByDirname($dirname);
	if (!is_object($module)) {
		exit('Access Denied');
	}

	// get xoonips user information
	$userBean = Xoonips_BeanFactory::getBean('UsersBean', XCUBE_CORE_USER_MODULE_NAME);
	$userInfo = $userBean->getUserBasicInfo($uid);
	if (!$userInfo) {
		// not xoonips user
		return false;
	}
	$is_certified = $userInfo['activate'];
	if ($is_certified != 2) {
		// user is not certified
		return false;
	}
	$uname = $xoopsUser->getVar('uname', 's');
	$is_admin = $userBean->isModerator($uid);

	// get count of private messages
	$pm_handler =& xoops_gethandler('privmessage');
	$criteria = new CriteriaCompo(new Criteria('read_msg', 0));
	$criteria->add( new Criteria('to_userid', $uid));
	$new_messages = $pm_handler->getCount($criteria);
	
	// check workflow authen
	$hasWorkflowAuthen = false;
	XCube_DelegateUtils::call('Legacy_Workflow.CheckAuthen', new XCube_Ref($hasWorkflowAuthen));
 
	// assign block template variables
	$block = array(
		'is_su' => isset($_SESSION[$dirname . '_old_uid']),
		'uid' => $uid,
		'new_messages' => $new_messages,
		'hasWorkflowAuthen' => $hasWorkflowAuthen, 
		'lang_su_end' => sprintf(_MB_XOONIPS_USER_SU_END, $uname),
		'xoonips_isadmin' => $is_admin,
		'dirname' => $dirname);
	if ($hasWorkflowAuthen == true) {
		// count my task 
		$mytaskCnt = 0;
		XCube_DelegateUtils::call('Legacy_Workflow.CountMyTask', new XCube_Ref($mytaskCnt));	  
		$block['myTaskCnt'] = $mytaskCnt; 
	}
	return $block;
}

