<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . '/legacy/class/interface/WorkflowClientDelegateInterface.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/WorkflowFactory.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';
require_once XOONIPS_TRUST_PATH . '/class/core/Notification.class.php';

class Xoonips_DelegateFunctions { // implements Legacy_iWorkflowClientDelegate
	/**
	 * getModuleUsingProgress
	 *
	 * @param mixed[] $list
	 *
	 * @return	void
	 */ 
	public function getManagedModules(/*** array ***/ &$list) {
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$list[] = array('dirname' => $dirname, 'dataname'=>'user approvel1');
			$list[] = array('dirname' => $dirname, 'dataname'=>'group approvel');
		}
	}

	/**
	 * getSourceUrl
	 *
	 * @param string &$url
	 * @param string $dirname
	 * @param string $dataname
	 * @param int $id
	 *
	 * @return	void
	 */ 
	public function getSourceUrl(/*** string ***/ &$url, /*** string ***/ $dirname, /*** string ***/ $dataname, /*** int ***/ $id) {
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $xoonipsDirname) {
			if ($dirname == $xoonipsDirname && $dataname == 'story') {
				$url = XOOPS_URL . '/modules/' . $dirname . '/index.php?action=StoryView&story_id=' . $id;
			}
		}
	}

	/**
	 * updateStatus
	 *
	 * @param bool &$result
	 * @param string $dirname
	 * @param string $dataname
	 * @param int $id
	 *
	 * @return	void
	 */ 
	public function updateStatus(/*** bool ***/ &$result, /*** string ***/ $type_id, /*** string ***/ $module, /*** int ***/ $id, /*** int ***/ $status, /*** string ***/ $comment = '') {
		$temp = explode ('.', $module);
		$dirname = $temp[0];
		$c = $temp[1];
		$handler =& xoops_gethandler('module');
		$module =& $handler->getByDirname($dirname);
		$trustDirname = $module->get('trust_dirname');
		if ($trustDirname == XOONIPS_TRUST_DIRNAME) {
			$workflow = Xoonips_WorkflowFactory::getWorkflow($c, $dirname, $trustDirname);
			if ($status == Lenum_WorkflowStatus::FINISHED) {
				$workflow->doCertify($id, $result, $comment);
			} elseif ($status == Lenum_WorkflowStatus::PROGRESS) {
				$workflow->doProgress($id, $result, $comment);
			} elseif ($status == Lenum_WorkflowStatus::REJECTED) {
				$workflow->doRefuse($id, $result, $comment);
			}
		}
	}
	
	public function getDetailView(/*** string ***/ &$result, /*** string ***/ $type_id, /*** string ***/ $module, /*** int ***/ $id ) {
		$temp = explode ('.', $module);
		$dirname = $temp[0];
		$c = $temp[1];
		$handler =& xoops_gethandler('module');
		$module =& $handler->getByDirname($dirname);
		$trustDirname = $module->get('trust_dirname');
		if ($trustDirname == XOONIPS_TRUST_DIRNAME) {
			$workflow = Xoonips_WorkflowFactory::getWorkflow($c, $dirname, $trustDirname);
			$result .= $workflow->getDetailView($id);
		}
	}
	
	public function getTargetGroupId(/*** string ***/ &$result, /*** string ***/ $type_id, /*** string ***/ $module, /*** int ***/ $id ) {
		$temp = explode ('.', $module);
		$dirname = $temp[0];
		$c = $temp[1];
		$handler =& xoops_gethandler('module');
		$module =& $handler->getByDirname($dirname);
		$trustDirname = $module->get('trust_dirname');
		if ($trustDirname == XOONIPS_TRUST_DIRNAME) {
			$workflow = Xoonips_WorkflowFactory::getWorkflow($c, $dirname, $trustDirname);
			$indexItemLinkBean = null;
			list($itemId, $indexId, $groupId) = $workflow->getTargetGroupId($id, $indexItemLinkBean);
			$result .= $groupId;
		}
	}
	
	public function checkLoginSuccess($xoopsUser) {
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordLoginSuccessEvent($xoopsUser->get('uid'));
		}
	}
	
	public function checkLoginFail($uname) {		
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordLoginFailureEvent($uname);
		}
	}
	
	public function checkLogoutSuccess($xoopsUser) {	
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordLogoutEvent($xoopsUser->get('uid'));
		}	
	}
	
	public function userCertifyRequest($xoopsUser) {
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordRequestInsertAccountEvent($xoopsUser->get('uid'));
		}
	}

	private static function getUserExtendTableName($name) {
    	$module_handler =& xoops_gethandler('module');
		$module =& $module_handler->getByDirname(XCUBE_CORE_USER_MODULE_NAME);
		if (is_object($module)) {
			$trustDirname = $module->getVar('trust_dirname');
		} else {
			$trustDirname = 'user';
		}
		require_once XOOPS_TRUST_PATH . '/modules/' . $trustDirname . '/class/core/UserFieldManager.class.php';
    	$userFieldManager = User_UserFieldManager::getInstance(true);
    	foreach ($userFieldManager->getFields() as $field) {
    		if ($field->getXmlTag() == $name) {
				return $field->getTableName();    		
    		}
    	}
	}

	public function userCertify($xoopsUser) {	
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		$uid = $xoopsUser->get('uid');
		$userBean = Xoonips_BeanFactory::getBean('UsersBean', XCUBE_CORE_USER_MODULE_NAME);
		$indexTableName = self::getUserExtendTableName('index_id');
		foreach ($dirnameList as $dirname) {
			$indexBean = Xoonips_BeanFactory::getBean('IndexBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$index_id = $indexBean->insertPrivateIndex($uid);
			if ($index_id === false) {
				redirect_header(XOOPS_URL . '/', 3, 'Activation failed!');
			}

			if (!$userBean->setUserExtend($indexTableName, $uid, $index_id, 'int')) {
	    		redirect_header(XOOPS_URL . '/', 3, 'Activation failed!');
	    	}
		}
	    			
		//certification automatically
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);                  
			$log -> recordCertifyAccountEvent($uid);
		}
	}
	
	public function userReject($xoopsUser) {	
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log -> recordUncertifyAccountEvent($xoopsUser->get('uid'));
		}
	}

	public function userSuBegin($xoopsUser, $xoopsUser_su) {	
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordStartSuEvent($xoopsUser->get('uid'), $xoopsUser_su->get('uid'));
		}
	}

	public function userSuEnd($xoopsUser_old, $xoopsUser) {
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordEndSuEvent($xoopsUser_old->get('uid'), $xoopsUser->get('uid'));
		}
	}

	public function groupMemberLeave($xoopsUser, $xoopsGroup) {
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordDeleteGroupMemberEvent($xoopsUser->get('uid'), $xoopsGroup->get('groupid'));
		}		
	}

	public function groupMemberLeaveRequest($xoopsUser, $xoopsGroup) {
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordRequestLeaveGroupEvent($xoopsUser->get('uid'), $xoopsGroup->get('groupid'));
		}
	}

	public function groupMemberLeaveCertify($xoopsUser, $xoopsGroup) {
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordCertifyLeaveGroupEvent($xoopsUser->get('uid'), $xoopsGroup->get('groupid'));
		}
	}
	
	public function groupMemberLeaveReject($xoopsUser, $xoopsGroup) {
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordRejectLeaveGroupEvent($xoopsUser->get('uid'), $xoopsGroup->get('groupid'));
		}
	}
	
	public function groupMemberJoin($xoopsUser, $xoopsGroup){
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordInsertGroupMemberEvent($xoopsUser->get('uid'), $xoopsGroup->get('groupid'));
		}
	}
	
	public function groupMemberJoinRequest($xoopsUser, $xoopsGroup) {
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordRequestJoinGroupEvent($xoopsUser->get('uid'), $xoopsGroup->get('groupid'));
		}
	}

	public function groupMemberJoinCertify($xoopsUser, $xoopsGroup) {	
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordCertifyJoinGroupEvent($xoopsUser->get('uid'), $xoopsGroup->get('groupid'));
		}
	}

	public function groupMemberJoinReject($xoopsUser, $xoopsGroup) {
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordRejectJoinGroupEvent($xoopsUser->get('uid'), $xoopsGroup->get('groupid'));
		}
	}	

	public function groupDeleteRequest($xoopsGroup) {	
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordRequestDeleteGroupEvent($xoopsGroup->get('groupid'));
		}
	}

	public function groupDeleteCertify($xoopsGroup){	
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$indexbean = Xoonips_BeanFactory::getBean('IndexBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$indexDelete = $indexbean->deleteGroupIndex($xoopsGroup->get('groupid'));
			//delete index
			if (!$indexDelete) {
				redirect_header(XOOPS_URL . '/',3, 'delete error!');	
			}
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordDeleteGroupEvent($groupId);
		}
	}

	public function groupDeleteReject($xoopsGroup){
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordRejectDeleteGroupEvent($xoopsGroup->get('groupid'));
		}
	}

	public function groupCertifyRequest($xoopsGroup){	
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordRequestGroupEvent($xoopsGroup->get('groupid'));
		}
	}
	
	public function groupEdit($xoopsGroup) {
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		$groupbean = Xoonips_BeanFactory::getBean('GroupsBean', XCUBE_CORE_USER_MODULE_NAME);
		$group= $groupbean->getGroup($xoopsGroup->get('groupid'));
		$index = array('parent_index_id' => 1,
			'groupid' => $group['groupid'],
			'open_level' => 2,
			'title' => $group['name']
		);
		foreach ($dirnameList as $dirname) {
			$indexBean = Xoonips_BeanFactory::getBean('IndexBean', $dirname, XOONIPS_TRUST_DIRNAME);
			//update index
			if (!$indexBean->updateRootGroupIndex($index)) {
				$response->setSystemError('DB error!');
				return false;
			}
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordUpdateGroupEvent($xoopsGroup->get('groupid'));
		}
	}
	
	public function groupOpenRequest($xoopsGroup){
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordRequestGroupOpenEvent($xoopsGroup->get('groupid'));
		}
	}

	public function groupOpenCertify($xoopsGroup){
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordCertifyGroupOpenEvent($xoopsGroup->get('groupid'));
			$statusBean = Xoonips_BeanFactory::getBean('OaipmhItemStatusBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$statusBean->insertByGroupOpen($xoopsGroup->get('groupid'));
			$statusBean->updateByGroupOpen($xoopsGroup->get('groupid'));
		}
	}

	public function groupOpenReject($xoopsGroup){
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordRejectGroupOpenEvent($xoopsGroup->get('groupid'));
		}
	}

	public function groupCloseRequest($xoopsGroup){
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordRequestGroupCloseEvent($xoopsGroup->get('groupid'));
		}
	}

	public function groupCloseCertify($xoopsGroup){
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordCertifyGroupCloseEvent($xoopsGroup->get('groupid'));
			$statusBean = Xoonips_BeanFactory::getBean('OaipmhItemStatusBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$statusBean->deleteByGroupOpen($xoopsGroup->get('groupid'));
		}
	}
	public function groupCloseReject($xoopsGroup){
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordRejectGroupCloseEvent($xoopsGroup->get('groupid'));
		}
	}

	public function groupCertify($xoopsGroup){
   		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		$groupbean = Xoonips_BeanFactory::getBean('GroupsBean', XCUBE_CORE_USER_MODULE_NAME);	   
		$group= $groupbean->getGroup($xoopsGroup->get('groupid'));
		$index = array('parent_index_id' => 1,
			'groupid' => $xoopsGroup->get('groupid'),
			'open_level' => 2,
			'title' => $group['name']
		);
		foreach ($dirnameList as $dirname) {
		    $indexbean = Xoonips_BeanFactory::getBean('IndexBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$index_id = $indexbean->insertGroupIndex($index);
			//insert index
			if (!$index_id) {
				redirect_header(XOOPS_URL . '/',3,'DB error!');			
			}	
			//update group index
			if (!$groupbean->updateGroupIndex($xoopsGroup->get('groupid'), $index_id)) {
				redirect_header(XOOPS_URL . '/',3,'DB error!');
			}
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordCertifyGroupEvent($xoopsGroup->get('groupid'));
		}
	}
	
	public function groupReject($xoopsGroup){
   		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$log->recordRejectGroupEvent($xoopsGroup->get('groupid'));
		}
	}

	public function userDelete($xoopsUser){
		global $xoopsDB;
		$uid = $xoopsUser->get('uid');
		$userBean = Xoonips_BeanFactory::getBean('UsersBean', XCUBE_CORE_USER_MODULE_NAME);
   		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$notification = new Xoonips_Notification($xoopsDB, $dirname, XOONIPS_TRUST_DIRNAME);
			$itemBean = Xoonips_BeanFactory::getBean('ItemBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$itemUsersBean = Xoonips_BeanFactory::getBean('ItemUsersLinkBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$itemTitleBean = Xoonips_BeanFactory::getBean('ItemTitleBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$itemKeywordBean = Xoonips_BeanFactory::getBean('ItemKeywordBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$itemRelatedToBean = Xoonips_BeanFactory::getBean('ItemRelatedToBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$itemExtendBean = Xoonips_BeanFactory::getBean('ItemExtendBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$itemFileBean = Xoonips_BeanFactory::getBean('ItemFileBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$changeLogBean = Xoonips_BeanFactory::getBean('ItemChangeLogBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$indexBean = Xoonips_BeanFactory::getBean('IndexBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$indexItemLink = Xoonips_BeanFactory::getBean('IndexItemLinkBean', $dirname, XOONIPS_TRUST_DIRNAME);
			// delete items
			$itemIdSingle = array();
			$itemIdSingle = $itemUsersBean->getItemsWithOwner($uid);		
			if ($itemIdSingle != false && count($itemIdSingle) != 0) {
				$itemExtendTable = $itemExtendBean->getItemExtendTable();
				foreach ($itemIdSingle as $itemSingle) {
					if (!$itemBean->delete($itemSingle['item_id']) 
							|| !$itemUsersBean->delete($itemSingle['item_id']) 
							|| !$itemTitleBean->delete($itemSingle['item_id']) 
							|| !$itemKeywordBean->delete($itemSingle['item_id']) 
							|| !$itemRelatedToBean->deleteBoth($itemSingle['item_id'])  
							|| !$itemFileBean->delete($itemSingle['item_id'])
							|| !$changeLogBean->delete($itemSingle['item_id'])) {					 	
						redirect_header(XOOPS_URL . '/', 3, 'delete error!');
					} else {
						$log->recordDeleteItemEvent($itemSingle['item_id']);
					}
					//delete item_extend
					if (count($itemExtendTable) != 0) {
						foreach ($itemExtendTable as $tableName) {
							if (!$itemExtendBean->delete($itemSingle['item_id'], $tableName)) {							
								redirect_header(XOOPS_URL . '/', 3, 'delete itemExtend error!');
							}
						}
					}
				}
			}
			// delete item users
			$itemIdMore = array();
			$itemIdMore = $itemUsersBean->getItemsWithOwners($uid);		
			if ($itemIdMore != false && count($itemIdMore) != 0) {
				if (!$itemUsersBean->deleteAllByUid($uid)) {				
					redirect_header(XOOPS_URL . '/', 3, 'delete groupItemUsers error!');
				} else {
					foreach ($itemIdMore as $itemMore) {
						$itemUsersInfo = $itemUsersBean->getItemUsersInfo($itemMore['item_id']);
						$itemUsersId = array();
						foreach ($itemUsersInfo as $itemUser) {
							$itemUsersId[] = $itemUser['uid'];
						}	
						//log :57
						$log->recordDeleteItemUserEvent($itemMore['item_id'], $uid);
						//event
						if ($itemUsersId != false && count($itemUsersId) != 0) {
							$notification->userDeleteItemUser($itemMore['item_id'], $userInfo['uname'], $itemUsersId);
						}
					}
				}
			}
			//delete index
			$indexIds = array();
			$indexIds = $indexBean->getPrivateIndexes($uid);		
			if (!$indexBean->deleteIndexByUid($uid)) {			
				redirect_header(XOOPS_URL . '/', 3, 'delete index error!');
			}
			//delete index_item_link
			if ($indexIds != false && count($indexIds) != 0) {
				foreach ($indexIds as $indexId) {
					if (!$indexItemLink->deleteByIndexId($indexId['index_id'])) {					
						redirect_header(XOOPS_URL . '/', 3, 'delete indexItemLink error!');
					} else {
						$log->recordDeleteIndexEvent($indexId['index_id']);
					}
				}
			}
	
			// user delete log
			$log->recordDeleteAccountEvent($uid);
		}
	}

	public function recountPosts(&$posts, $xoopsUser){
   		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$itemBean = Xoonips_BeanFactory::getBean('ItemVirtualBean', $dirname, XOONIPS_TRUST_DIRNAME);	
			$itemBean->getPosts($xoopsUser->get('uid'), $posts);
		}
	}

	public function getUserMaximumResources(&$resources, $xoopsUser){
   		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		$usersBean = Xoonips_BeanFactory::getBean('UsersBean', XCUBE_CORE_USER_MODULE_NAME);
		if (!is_null($xoopsUser)) {
			$itemNumberLimit = $usersBean->getUserExtend(self::getUserExtendTableName('item_number_limit'), $xoopsUser->get('uid'));
			$indexNumberLimit = $usersBean->getUserExtend(self::getUserExtendTableName('index_number_limit'), $xoopsUser->get('uid'));
			$itemStorageLimit = $usersBean->getUserExtend(self::getUserExtendTableName('item_storage_limit'), $xoopsUser->get('uid'));
		}
		foreach ($dirnameList as $dirname) {
			$configBean = Xoonips_BeanFactory::getBean('ConfigBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$resources[$dirname] = array('itemNumberLimit' => (empty($itemNumberLimit[0]['value'])) ? $configBean->getConfig('private_item_number_limit') : $itemNumberLimit[0]['value'],
				'indexNumberLimit' => (empty($indexNumberLimit[0]['value'])) ? $configBean->getConfig('private_index_number_limit') : $indexNumberLimit[0]['value'],
				'itemStorageLimit' => (empty($itemStorageLimit[0]['value'])) ? $configBean->getConfig('private_item_storage_limit') : $itemStorageLimit[0]['value']
			);
		}
	}

	public function getUserUsedResources(&$resources, $xoopsUser){
   		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$itemBean = Xoonips_BeanFactory::getBean('ItemVirtualBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$indexBean = Xoonips_BeanFactory::getBean('IndexBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$fileBean = Xoonips_BeanFactory::getBean('ItemFileBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$resources[$dirname] = array('itemNum' => $itemBean->countUserItems($xoopsUser->get('uid')),
				'indexNum' => $indexBean->countUserIndexes($xoopsUser->get('uid')),
				'fileSize' => $fileBean->countUserFileSizes($xoopsUser->get('uid'))
			);
		}
	}

	public function getGroupMaximumResources(&$resources, $xoopsGroup){
   		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		$groupBean = Xoonips_BeanFactory::getBean('GroupsBean', XCUBE_CORE_USER_MODULE_NAME);
		if (!is_null($xoopsGroup)) {
			$groupInfo = $groupBean->getGroup($xoopsGroup->get('groupid'));
		}
		foreach ($dirnameList as $dirname) {
			$configBean = Xoonips_BeanFactory::getBean('ConfigBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$resources[$dirname] = array('itemNumberLimit' => (empty($groupInfo['item_number_limit'])) ? $configBean->getConfig('group_item_number_limit') : $groupInfo['item_number_limit'],
				'indexNumberLimit' => (empty($groupInfo['index_number_limit'])) ? $configBean->getConfig('group_index_number_limit') : $groupInfo['index_number_limit'],
				'itemStorageLimit' => (empty($groupInfo['item_storage_limit'])) ? $configBean->getConfig('group_item_storage_limit') : $groupInfo['item_storage_limit']
			);
		}
	}

	public function getGroupUsedResources(&$resources, $xoopsGroup){
   		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$itemBean = Xoonips_BeanFactory::getBean('ItemVirtualBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$indexBean = Xoonips_BeanFactory::getBean('IndexBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$fileBean = Xoonips_BeanFactory::getBean('ItemFileBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$resources[$dirname] = array('itemNum' => $itemBean->countGroupItems($xoopsGroup->get('groupid')),
				'indexNum' => $indexBean->countGroupIndexes($xoopsGroup->get('groupid')),
				'fileSize' => $fileBean->countGroupFileSizes($xoopsGroup->get('groupid'))
			);
		}
	}

	public function getModerators(&$moderators){
   		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$configBean = Xoonips_BeanFactory::getBean('ConfigBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$moderator_gid = $configBean->getConfig('moderator_gid');
			if (is_null($moderator_gid)) {
				return false; // no moderator
			}
			$group_handler =& xoops_gethandler('group');
			$moderator = $group_handler->get($moderator_gid);
			if ($moderator) {
				$moderators[] = $moderator;
			}
		}
	}

	public function userDeleteCondition(&$ret, $xoopsUser){
		$uid = $xoopsUser->get('uid');
		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$itemUsersBean = Xoonips_BeanFactory::getBean('ItemUsersLinkBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$ret[$dirname][0] = $itemUsersBean->isItemUser($uid);
			$ret[$dirname][1] = _MD_XOONIPS_ERROR_ITEM_FAILED;
		}
	}

	public function groupLeaveCondition(&$ret, $xoopsGroup, $xoopsUser){
   		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		foreach ($dirnameList as $dirname) {
			$itemBean = Xoonips_BeanFactory::getBean('ItemVirtualBean', $dirname, XOONIPS_TRUST_DIRNAME);
			$ret[$dirname] = $itemBean->isItemGroup($xoopsGroup->get('groupid'), $xoopsUser->get('uid'));
		}
	}

	public function getMessageSign(&$resources){
   		$dirnameList = Legacy_Utils::getDirnameListByTrustDirname(XOONIPS_TRUST_DIRNAME);
		$myxoopsConfig = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF);
		$config_keys = array(
		  'message_sign_site' => 's',
		  'message_sign_siteurl' => 's',
		  'message_sign_adminmail' => 's',
		);
		foreach ($dirnameList as $dirname) {
			$config_values = Xoonips_Utils::xoonipsAdminGetConfigs($config_keys, 'e', $dirname, XOONIPS_TRUST_DIRNAME);
			if ($config_values['message_sign_site'] == NULL && $config_values['message_sign_siteurl'] == NULL && $config_values['message_sign_adminmail'] == NULL) {
				$resources[$dirname] = array(
			 		'sitename' =>  $myxoopsConfig['sitename'],
			 		'adminmail' => $myxoopsConfig['adminmail'],
			 		'siteurl' => XOOPS_URL . '/',
				);
			} else {
				$resources[$dirname] = array(
				 'sitename' =>  $config_values['message_sign_site'],
				 'adminmail' => $config_values['message_sign_adminmail'],
				 'siteurl' => $config_values['message_sign_siteurl'],
				);
			}
		}
	}
}

