<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/ViewType.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';
require_once  dirname( dirname( dirname( __FILE__ ) ) ) . '/include/itemtypetemplate.inc.php';

class Xoonips_ViewTypeRelatedTo extends Xoonips_ViewType {

	public function setTemplate() {
		$this->template = $this->dirname . '_viewtype_relatedTo.html';
	}

	public function getInputView($field, $value, $groupLoopId) {
		$itemInfo = array();
		if (!empty($value)) {
			$vas = explode(',', $value);
			foreach ($vas as $va) {
				$itemInfo[] = array('listInfo' => $this->getItemInfo($va), 'id' => $va);
			}
		}
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$divName = $fieldName . '_div';
   		$this->getXoopsTpl()->assign('viewType', 'input');
   		$this->getXoopsTpl()->assign('dirname', $this->dirname);
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('divName', $divName);
		$this->getXoopsTpl()->assign('value', $value);
		$this->getXoopsTpl()->assign('itemInfo', $itemInfo);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	public function getEditView($field, $value, $groupLoopId) {
		return $this->getInputView($field, $value, $groupLoopId);
	}

	public function getDisplayView($field, $value, $groupLoopId) {
		$itemInfo = array();
		if (!empty($value)) {
			$vas = explode(',', $value);
			foreach ($vas as $va) {
				$itemInfo[] = $this->getItemInfo($va);
			}
		}
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$divName = $fieldName . '_div';
   		$this->getXoopsTpl()->assign('viewType', 'confirm');
   		$this->getXoopsTpl()->assign('dirname', $this->dirname);
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('divName', $divName);
		$this->getXoopsTpl()->assign('value', $value);
		$this->getXoopsTpl()->assign('itemInfo', $itemInfo);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	public function getDetailDisplayView($field, $value, $display) {
		$itemInfo = array();
		if (!empty($value)) {
			$vas = explode(',', $value);
			foreach ($vas as $va) {
				$itemInfo[] = $this->getItemInfo($va);
			}
		}
   		$this->getXoopsTpl()->assign('viewType', 'detail');
		$this->getXoopsTpl()->assign('value', $value);
		$this->getXoopsTpl()->assign('itemInfo', $itemInfo);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	public function getMetaInfo($field, $value) {
		$ret = '';
		$fields = array();
		if (!empty($value)) {
			$vas = explode(',', $value);
			foreach ($vas as $va) {
				$fields[]= $va;
			}
		}
		return $ret.implode("\r\n", $fields);
	}

	public function getSearchView($field, $groupLoopId) {
		$fieldName = $this->getFieldName($field, $groupLoopId);
   		$this->getXoopsTpl()->assign('viewType', 'search');
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	public function inputCheck(&$errors, $field, $value, $fieldName) {
		return true;
	}

	public function editCheck(&$errors, $field, $value, $fieldName, $uid) {
		return true;
	}

	private function getItemInfo($iid) {
		$itemBean = Xoonips_BeanFactory::getBean('ItemVirtualBean', $this->dirname, $this->trustDirname);
		$itemInfo = $itemBean->getItem2($iid);
		return $itemBean->getItemListHtml($itemInfo);
	}

	public function doRegistry($field, &$data, &$sqlStrings, $groupLoopId) {
		$tableName = $field->getTableName();
		$columnName = $field->getColumnName();
		$value = $data[$this->getFieldName($field, $groupLoopId)];

		$tableData;
		$columnData;

		if (isset($sqlStrings[$tableName])) {
			$tableData = &$sqlStrings[$tableName];
		} else {
			$tableData = array();
			$sqlStrings[$tableName] = &$tableData;
		}

		if (isset($tableData[$columnName])) {
			$columnData = &$tableData[$columnName];
		} else {
			$columnData = array();
			$tableData[$columnName] = &$columnData;
		}

		if ($value != '') {
			$vas = explode(',', $value);
			foreach ($vas as $va) {
				$columnData[] = $va;
			}
		}
	}
	
	public function getMetadata($field, &$data) {
		$table = $field->getTableName();
		$column = $field->getColumnName();
		$itemBean = Xoonips_BeanFactory::getBean('ItemBean', $this->dirname, $this->trustDirname);
		$configBean = Xoonips_BeanFactory::getBean('ConfigBean', $this->dirname, $this->trustDirname);
		$database_id = $configBean->getConfig(XOONIPS_CONFIG_REPOSITORY_NIJC_CODE);
		$fields = array();
		foreach ($data[$table] as $value) {
			$item = $itemBean->getItemBasicInfo($value[$column]);
			$doi = $item['doi'];
			if ($doi == null) {
				$fields[] = "$database_id/$item_type_id.$item_id";
			} else {
				$fields[] = "$database_id:" . XOONIPS_CONFIG_DOI_FIELD_PARAM_NAME . "/$doi";
			}
		}
		return implode(',', $fields);
	}
	
	/**
	 *
	 * get default value block view
	 *
	 * @param $list, $value, $disabled
	 * @return string
	 */
	public function getDefalutValueBlockView($list, $value, $disabled = '') {
		$this->getXoopsTpl()->assign('viewType', 'default');
		$this->getXoopsTpl()->assign('value', $value);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}
	
	/**
	 *
	 * must Create item_extend table
	 *
	 * @param
	 * @return boolean
	 */
	public function mustCreateItemExtendTable() {
		return false;
	}
}

