// -*-C++-*-
#ifndef _lisp_h_
# define _lisp_h_

# include "cdecl.h"

# define QUIT check_quit ()
# define QUITP (xsymbol_value (Vquit_flag) != Qnil \
                && xsymbol_value (Vinhibit_quit) == Qnil)

class lisp_object
{
  lisp_object ();
public:
  void operator delete (void *){}
};

typedef lisp_object *lisp;

# include "signal.h"
# include "data.h"
# include "utils.h"

extern lisp Qnil;
extern lisp Qunbound;

/*
   DATA TYPE REPRESENTATIONS

   B: Data bit
   P: Pointer address bit

                  MSB ........ ........ ........ ........  LSB
IMMEDIATE:
   Short Integer:     BBBBBBBB BBBBBBBB BBBBBBBB BBBBBB01
   Character:         BBBBBBBB BBBBBBBB 00000000 00000111
   Message:           BBBBBBBB BBBBBBBB 00000000 00001011
POINTER:
                      PPPPPPPP PPPPPPPP PPPPPPPP PPPPPP00

   |C^l̍ŉʃrbgΑlǂ킩B
 */

# define IMMEDIATE_BIT 1
# define SHORT_INT_TEST_BITS (2 | IMMEDIATE_BIT)

# define LSHORT_INT_SHIFT 2

# define Lshort_int IMMEDIATE_BIT
# define Lchar ((1 << LSHORT_INT_SHIFT) | SHORT_INT_TEST_BITS)
# define Lmessage ((2 << LSHORT_INT_SHIFT) | SHORT_INT_TEST_BITS)

enum message_code;

enum lisp_object_type_bits
{
  // zp
  TAarray     = 0x80000000,  // z
  TAvector    = 0x40000000,  // xN^
  TAsimple    = 0x20000000,  // Pz
  TAtype_mask = 0x1f000000,  // ž^̃}XN
    TAgeneral = 0x10000000,  // ʔz
    TAstring  = 0x08000000,  // z
    TAfixnum  = 0x04000000,  // fixnumz(łĂȂ)
    TAbit     = 0x02000000,  // bitz(łĂȂ)

  // lp
  TNfixnum    = 0x00800000,  // fixnum
  TNbignum    = 0x00400000,  // bignum
  TNinteger   = 0x00200000,  // integer (fixnum|bignumƂႤ񂩂?)
  TNrational  = 0x00100000,  // L
  TNfloat     = 0x00080000,  // _
  TNreal      = 0x00040000,  // 
  TNnumber    = 0x00020000   // 
};

enum lisp_object_type
{
  Tarray                 = TAarray | TAgeneral,     // ʔz
  Tstring_array          = TAarray | TAstring,      // z
  Tfixnum_array          = TAarray | TAfixnum,      // fixnumz(܂łĂȂ)
  Tbit_array             = TAarray | TAbit,         // bitz(܂łĂȂ)

  Tcomplex_vector        = TAarray | TAvector | TAgeneral,             // ʃxN^
  Tsimple_vector         = TAarray | TAvector | TAgeneral | TAsimple,  // ʒPxN^
  Tcomplex_string        = TAarray | TAvector | TAstring,              // 
  Tsimple_string         = TAarray | TAvector | TAstring  | TAsimple,  // P
  Tcomplex_fixnum_vector = TAarray | TAvector | TAfixnum,              // fixnumxN^
  Tsimple_fixnum_vector  = TAarray | TAvector | TAfixnum  | TAsimple,  // PfixnumxN^
  Tcomplex_bit_vector    = TAarray | TAvector | TAbit,                 // bitxN^
  Tsimple_bit_vector     = TAarray | TAvector | TAbit     | TAsimple,  // PbitxN^

  // lȐBۂɂ̃^OIuWFNg݂͑ȂB
  Tshort_intP   = TNnumber | TNreal | TNrational | TNinteger | TNfixnum | 0,
  // lłȂB30bit32bitɂǂꂾႢƂ˂܂Ȃ悤ɁB
  // ̂͑lȐ͂Ȃ̂B
  Tlong_int     = TNnumber | TNreal | TNrational | TNinteger | TNfixnum | 1,
  Tbignum       = TNnumber | TNreal | TNrational | TNinteger | TNbignum, // bignum
  Tfraction     = TNnumber | TNreal | TNrational,      // 
  Tsingle_float = TNnumber | TNreal | TNfloat | 1,     // Px_
  Tdouble_float = TNnumber | TNreal | TNfloat | 2,     // {x_
  Tcomplex      = TNnumber,                            // f

  TnilP = 0,             // _~[
  TanyP,                 // _~[(ȂłȂ񂪂?)
  TimmediateP,           // l킷^^O
  TcharP,                // IuWFNg̋^^O
  TmessageP,             // bZ[WIuWFNg̋^^O
  Tcons,                 // RX
  Tsymbol,               // V{
  Tclosure,              // LVJN[W
  Tfunction,             // lCeBu֐
  Thash_table,           // nbVe[u
  Tstream,               // Xg[
  Tpackage,              // pbP[W
  Trandom_state,         // _Xe[g
  Tstruct_def,           // \̂̌^
  Tstruct_data,          // \̂̃CX^X
  Tchunk,                // ėpobt@̈
  Tdll_module,           // DLL
  Tdll_function,         // DLL̊֐
  Tc_callable,           // CĂׂ֐
  Twindow,               // EBhE
  Tbuffer,               // obt@
  Tmarker,               // }[J
  Tsyntax_table,         // V^bNXe[u
  Tprocess,              // vZX
  Tregexp,               // RpCK\
  Twin32_menu,           // j[
  Twin32_dde_handle,     // DDE
  Terror,                // G[IuWFNg
  Toledata,              // IDispatch
  Treadtable,            // readtable
  Twait_object,          // wait-object
  Tchar_encoding,        // character encoding scheme
  Tenvironment           // environment object
};

class lcons;
class lsymbol;

class lex_env;

typedef lisp (__stdcall *lfunction_proc)();
typedef lisp (__stdcall *lfunction_proc_0)();
typedef lisp (__stdcall *lfunction_proc_1)(lisp);
typedef lisp (__stdcall *lfunction_proc_2)(lisp, lisp);
typedef lisp (__stdcall *lfunction_proc_3)(lisp, lisp, lisp);

# include "fns.h"
# ifndef EXTERN
#  define EXTERN extern
# endif
# include "vars-decl.h"
# include "fns-decl.h"

# include "msgcode.h"

inline u_short
lowbits (pointer_t x)
{
  return u_short (x & 0xffff);
}

inline u_short
hibits (pointer_t x)
{
  return u_short ((x >> 16) & 0xffff);
}

inline lisp
make_immediate (u_short type, u_short data)
{
  return lisp ((pointer_t (data) << 16) | type);
}

inline u_short
ximmediate_data (lisp x)
{
  return hibits (pointer_t (x));
}

inline int
immediatep (lisp x)
{
  return pointer_t (x) & IMMEDIATE_BIT;
}

inline int
pointerp (lisp x)
{
  return !immediatep (x);
}

/* Lisp Object̃^O擾B炩߃|C^ł邱ƂmF邱ƁB
  lnƊԈႢȂʁB */
inline int
object_typeof (lisp x)
{
  assert (x);
  assert (pointerp (x));
  assert (bitisset (used_place (x), bit_index (x)));
  /* ldata_repLDATA_PAGE_SIZEEɂ邩炱Ń^O */
  return ((ldata_rep *)(pointer_t (x) & ~LDATA_PAGE_MASK))->dr_type;
}

inline int
typep (int x, lisp_object_type type)
{
  return x == type;
}

/* xObject^Cv^Oƈv邩ǂ?
   pointerp()Ăł̂ŁÃIuWFNg^Cvƈv邩
   `FbNꍇ́A炩߃^OoĂBGCCȂ
   炸AVC̃IveB}CU܂œƂ͎vB*/
inline int
typep (lisp x, lisp_object_type type)
{
  return pointerp (x) && typep (object_typeof (x), type);
}

/* xObject^CvtypełȂtype-erroroB
   expected͊҂^B */
inline void
check_type (lisp x, lisp_object_type type, lisp expected)
{
  if (!typep (x, type))
    FEtype_error (x, expected);
}

inline int
object_type_bit_p (int x, lisp_object_type_bits bit)
{
  return (x & bit) == bit;
}

inline int
object_type_bit_p (lisp x, lisp_object_type_bits bit)
{
  return pointerp (x) && object_type_bit_p (object_typeof (x), bit);
}

inline int
object_type_mask_p (int x, int mask, int test)
{
  return (x & mask) == test;
}

inline int
object_type_mask_p (lisp x, int mask, int test)
{
  return pointerp (x) && object_type_mask_p (object_typeof (x), mask, test);
}

/* x̃Tu^CvbitłȂtype-errorfB
   expected͊҂^B */
inline void
check_object_type_bit (lisp x, lisp_object_type_bits bit, lisp expected)
{
  if (!object_type_bit_p (x, bit))
    FEtype_error (x, expected);
}

inline lisp
boole (int x)
{
  return x ? Qt : Qnil;
}

inline lisp
boole (void *x)
{
  return x ? Qt : Qnil;
}

/* srcdstsizeLisp ObjectRs[B
   memcpyƂsrcdsttȂ̂ŒӁB
   BSDbcopyƂƈႤBChar*pbcopyB*/
inline void
bcopy (lisp *src, lisp *dst, size_t size)
{
  memcpy (dst, src, sizeof (lisp) * size);
}

# include "cons.h"
# include "symbol.h"

void handle_quit ();

inline void
check_quit ()
{
  if (QUITP)
    handle_quit ();
}

# include "function.h"
# include "closure.h"
# include "number.h"
# include "char.h"
# include "list.h"
# include "vector.h"
# include "string.h"
# include "stream.h"
# include "package.h"
# include "hash.h"
# include "message.h"
# include "error.h"
# include "trace.h"
# include "random.h"
# include "structure.h"
# include "readtab.h"

class protect_gc
{
  static protect_gc *gcl;
  protect_gc *last;
  int nvars;
  lisp *var;
  void chain ();
public:
  protect_gc (lisp &);
  protect_gc (lisp *, int);
  ~protect_gc ();
  friend void gc_mark_object ();
};

inline void
protect_gc::chain ()
{
  last = gcl;
  gcl = this;
}

inline
protect_gc::protect_gc (lisp &v)
{
  var = &v;
  nvars = 1;
  chain ();
}

inline
protect_gc::protect_gc (lisp *v, int n)
{
  var = v;
  nvars = n;
  chain ();
}

inline
protect_gc::~protect_gc ()
{
  gcl = last;
}

class dyn_protect_gc
{
  static dyn_protect_gc *gcl;
  dyn_protect_gc *prev;
  dyn_protect_gc *next;
  int nvars;
  lisp *var;
  void chain ()
    {
      prev = 0;
      next = gcl;
      if (gcl)
        gcl->prev = this;
      gcl = this;
    }
public:
  dyn_protect_gc (lisp &v)
    {
      var = &v;
      nvars = 1;
      chain ();
    }
  dyn_protect_gc (lisp *v, int n)
    {
      var = v;
      nvars = n;
      chain ();
    }
  ~dyn_protect_gc ()
    {
      if (prev)
        prev->next = next;
      else
        gcl = next;
      if (next)
        next->prev = prev;
    }
  friend void gc_mark_object ();
};

/* special bind݂ */
class dynamic_bind
{
  lisp old;
  lisp var;
  int f;
  protect_gc pgc;
public:
  dynamic_bind (lisp, lisp);
  ~dynamic_bind ();
};

inline
dynamic_bind::dynamic_bind (lisp x, lisp val)
     : old (xsymbol_value (x)), var (x), f (xsymbol_flags (x) & SFdynamic_bind), pgc (old)
{
  assert (symbolp (var));
  xsymbol_value (var) = val;
  xsymbol_flags (var) |= SFdynamic_bind;
}

inline
dynamic_bind::~dynamic_bind ()
{
  xsymbol_value (var) = old;
  if (!f)
    xsymbol_flags (var) &= ~SFdynamic_bind;
  else
    assert (xsymbol_flags (var) & SFdynamic_bind);
}

/* ǏGOTO
   ͑SRZXȂB*/
struct nonlocal_data
{              // RETURN-FROM     GO      THROW    ERROR
  lisp type;   //   Qblock     Qtagbody   Qcatch   Qtoplevel   Qexit_this_level
  lisp value;  //   VALUE      Qnil       VALUE    Qnil        VALUE
  lisp tag;    //   TAG        TAG        TAG      Qnil        Qnil
  lisp id;     //   FRAME-ID   FRAME-ID   Qnil     CONDITION   Qt/Qnil

  nonlocal_data () : type (Qnil), value (Qnil), tag (Qnil), id (Qnil) {}
};

class nonlocal_jump
{
  static nonlocal_data *d;
public:
  static nonlocal_data *data ();
  friend class save_nonlocal_jump;
};

inline nonlocal_data *
nonlocal_jump::data ()
{
  return d;
}

/* ѐꎞҔ(unwind-protectprotected-formp) */
class save_nonlocal_jump
{
  protect_gc pgc;
  nonlocal_data *last;
  nonlocal_data data;
public:
  save_nonlocal_jump ();
  ~save_nonlocal_jump ();
};

inline
save_nonlocal_jump::save_nonlocal_jump ()
     : pgc ((lisp *)nonlocal_jump::d, sizeof *nonlocal_jump::d / sizeof (lisp))
{
  last = nonlocal_jump::d;
  nonlocal_jump::d = &data;
}

inline
save_nonlocal_jump::~save_nonlocal_jump ()
{
  nonlocal_jump::d = last;
}

/* l̃obt@
   ʂɑlԂ֐values[0]ɒlꂸɖ߂lŕԂ̂ŁA
  obt@̒ggꍇ͒ӁB*/

# define MULTIPLE_VALUES_LIMIT 32

struct multiple_value_data
{
  int count;
  lisp values[MULTIPLE_VALUES_LIMIT];
};

class multiple_value
{
  static multiple_value_data *d;
public:
  static multiple_value_data *data ();
  static void clear ();
  static lisp *values ();
  static lisp &value (int);
  static int &count ();
  friend class save_multiple_value;
};

inline multiple_value_data *
multiple_value::data ()
{
  return d;
}

inline void
multiple_value::clear ()
{
  d->count = 1;
}

inline lisp *
multiple_value::values ()
{
  return d->values;
}

inline lisp &
multiple_value::value (int n)
{
  assert (n >= 0 && n < MULTIPLE_VALUES_LIMIT);
  return d->values[n];
}

inline int &
multiple_value::count ()
{
  return d->count;
}

class save_multiple_value
{
  protect_gc pgc;
  multiple_value_data *last;
  multiple_value_data data;
public:
  save_multiple_value (lisp);
  ~save_multiple_value ();
};

inline
save_multiple_value::save_multiple_value (lisp first)
     : pgc (multiple_value::d->values, multiple_value::d->count)
{
  multiple_value::d->values[0] = first;
  last = multiple_value::d;
  multiple_value::d = &data;
  data.values[0] = Qnil;
  data.count = 1;
}

inline
save_multiple_value::~save_multiple_value ()
{
  multiple_value::d = last;
}

/* ꎞIɎg镶B̑݊Ԓɕʂ̂Ƃ
   temporary_string𐶐Ȃ悤ɋCĎgȂ
   Ȃ̂ŁA܂gꏊȂB*/
class temporary_string
{
  Char *save;
public:
  temporary_string (Char *, int);
  ~temporary_string ();
  static lisp string ();
};

inline
temporary_string::temporary_string (Char *s, int l)
{
  assert (stringp (xsymbol_name (Qtemporary_string)));
  assert (!xstring_length (xsymbol_name (Qtemporary_string)));
  save = xstring_contents (xsymbol_name (Qtemporary_string));
  xstring_contents (xsymbol_name (Qtemporary_string)) = s;
  xstring_length (xsymbol_name (Qtemporary_string)) = l;
}

inline
temporary_string::~temporary_string ()
{
  xstring_contents (xsymbol_name (Qtemporary_string)) = save;
  xstring_length (xsymbol_name (Qtemporary_string)) = 0;
}

inline lisp
temporary_string::string ()
{
  return xsymbol_name (Qtemporary_string);
}

class suppress_gc
{
private:
  int sg_save;
  static int sg_suppress_p;
public:
  suppress_gc () : sg_save (sg_suppress_p) {sg_suppress_p = 1;}
  ~suppress_gc () {sg_suppress_p = sg_save;}
  static int gc_suppressed_p () {return sg_suppress_p;}
};

#endif /* not _lisp_h_ */
