﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Ubx
{
    public class NavTimeGps : Packet
    {
        #region constructors

        public NavTimeGps(byte[] sentence, int length)
            : base(sentence, length)
        {
        }

        #endregion

        #region properties

        public GpsTime GpsTime
        {
            get
            {
                return new GpsTime(Week, TimeOfWeek);
            }
        }

        public decimal TimeOfWeek
        {
            get
            {
                uint tow = BitConverter.ToUInt32(Raw, 6 + 0);
                int ftow = BitConverter.ToInt32(Raw, 6 + 4);
                return tow * 1e-3m + ftow * 1e-9m;
            }
        }

        public int Week
        {
            get
            {
                return BitConverter.ToInt16(Raw, 6 + 8);
            }
        }

        public int LeapSecond
        {
            get
            {
                return (sbyte)(Raw[6 + 10]);
            }
        }

        public decimal Accuracy
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 12) * 1e-9m;
            }
        }

        #endregion

        #region public methods

        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            return TryParse(sentence, out packet, 
                                            MessageID.NavTimeGps, 16, Build);
        }

        #endregion

        #region private methods

        private static Packet Build(byte[] sentence, int length)
        {
            return new NavTimeGps(sentence, length);
        }

        #endregion
    }
}
