﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using Yubeshi;
using Yubeshi.Nmea;
using P = YubeshiTest.NmeaTest.SamplePackets;

namespace YubeshiTest.NmeaTest
{

    class PacketTest
    {

        [Test]
        public void GpDtmTest()
        {
            UnknownPacket packet;
            Assert.IsTrue(GpDtm.TryParse(P.GpDtm, out packet));
            GpGga p = packet as GpGga;
        }

        [Test]
        public void GpGgaTest()
        {
            UnknownPacket packet;
            Assert.IsTrue(GpGga.TryParse(P.GpGga, out packet));
            GpGga p = packet as GpGga;
            Assert.AreEqual(new TimeSpan(0, 9, 27, 25, 0), p.TimeOfFix);
            Assert.AreEqual(2837.11399, p.Position.Latitude * 60.0);
            Assert.AreEqual(513.9159, p.Position.Longitude * 60.0);
        }
    }
}
