﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using Yubeshi.Nmea;
using P = YubeshiTest.NmeaTest.SamplePackets;

namespace YubeshiTest.NmeaTest
{

    class ParserTest
    {
        [Test]
        public void TryParse()
        { 
            Yubeshi.UnknownPacket p;

            Assert.IsFalse(Parser.TryParse(P.Dummy, out p));
            Assert.IsNull(p);

            Assert.IsTrue(Parser.TryParse(P.GpDtm, out p));
            Assert.IsTrue(p is GpDtm);

            Assert.IsTrue(Parser.TryParse(P.GpGga, out p));
            Assert.IsTrue(p is GpGga);

            Assert.IsTrue(Parser.TryParse(P.GpGll, out p));
            Assert.IsTrue(p is GpGll);

            Assert.IsTrue(Parser.TryParse(P.GpGrs, out p));
            Assert.IsTrue(p is GpGrs);

            Assert.IsTrue(Parser.TryParse(P.GpGsa, out p));
            Assert.IsTrue(p is GpGsa);
        }

        [Test]
        public void SearchSync()
        { 
            Encoding ascii = Encoding.ASCII;

            byte[] bufferNone = ascii.GetBytes("1234567890");
            Assert.AreEqual(-1, Parser.SearchSyncFrom(bufferNone));

            byte[] buffer0 = ascii.GetBytes(
                "$GPDTM,W84,,0.000000,N,0.000000,E,0.0,W84*6F\r\n$");
            Assert.AreEqual(0, Parser.SearchSyncFrom(buffer0));

            byte[] buffer10 = ascii.GetBytes(
                "1234567890$GPDTM,W84,,0.000000,N,0.000000,E,0.0,W84*6F\r\n$");
            Assert.AreEqual(10, Parser.SearchSyncFrom(buffer10));

            byte[] bufferEnd = ascii.GetBytes("1234567890$");
            Assert.AreEqual(10, Parser.SearchSyncFrom(bufferEnd));
        }
    }
}
