﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;
using Yubeshi;
using Yubeshi.Ubx;

namespace YubeshiTest.UbxTest
{
    class MyPacket : Packet
    {
        #region constructors

        public MyPacket(byte[] sentence, int length)
            : base(sentence, length)
        {   
            Content =BitConverter.ToUInt32(sentence, 6 + 0);
        }

        #endregion

        #region properties
        public uint Content
        {
            get;
            set;
        }
        #endregion

        #region public methods
        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            return TryParse(sentence, out packet, (MessageID)0xFFFF, 4, Build);
        }
        #endregion

        #region private methods

        private static Packet Build(byte[] sentence, int length)
        {
            return new MyPacket(sentence, length);
        }
        #endregion
    }
}
