﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using Yubeshi;
using Yubeshi.Ubx;
using P = YubeshiTest.UbxTest.SamplePackets;

namespace YubeshiTest.UbxTest
{

    class NavPacketTest
    {
        private readonly decimal timeOfWeek = 
            new TimeSpan(1, 23, 45, 6, 789).Ticks * 1e-7m;
        private readonly decimal timeOfWeekHD =
            new TimeSpan(1, 23, 45, 6, 789).Ticks * 1e-7m + 012345e-9m;

        [Test]
        public void NavClockTest()
        {
            UnknownPacket packet;
            Assert.IsTrue(NavClock.TryParse(P.NavClock, out packet));
            NavClock p = packet as NavClock;
            Assert.AreEqual(Packet.MessageID.NavClock, p.ID);
        }

        [Test]
        public void NavDopTest()
        {
            UnknownPacket packet;
            Assert.IsTrue(NavDop.TryParse(P.NavDop, out packet));
            NavDop p = packet as NavDop;
            Assert.AreEqual(Packet.MessageID.NavDop, p.ID);
        }

        [Test]
        public void NavPosEcefTest()
        {
            UnknownPacket packet;
            Assert.IsTrue(NavPosEcef.TryParse(P.NavPosEcef, out packet));
            NavPosEcef p = packet as NavPosEcef;
            Assert.AreEqual(Packet.MessageID.NavPosEcef, p.ID);
        }

        [Test]
        public void NavSolTest()
        {
            UnknownPacket packet;
            Assert.IsTrue(NavSol.TryParse(P.NavSol, out packet));
            NavSol p = packet as NavSol;
            Assert.AreEqual(Packet.MessageID.NavSol, p.ID);
            Assert.AreEqual(timeOfWeekHD, p.TimeOfWeek);
            Assert.AreEqual(-3961181.33, p.Position.X);
            Assert.AreEqual(3346187.67, p.Position.Y);
            Assert.AreEqual(3702487.20, p.Position.Z);
        }
    }
}
