﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using Yubeshi.Ubx;
using P = YubeshiTest.UbxTest.SamplePackets;

namespace YubeshiTest.UbxTest
{

    class ParserTest
    {
        [Test]
        public void TryParse()
        {
            Yubeshi.UnknownPacket p;

            Assert.IsFalse(Parser.TryParse(P.Dummy, out p));
            Assert.IsNull(p);

            Assert.IsTrue(Parser.TryParse(P.NavClock, out p));
            Assert.IsTrue(p is NavClock);

            Assert.IsTrue(Parser.TryParse(P.NavPosEcef, out p));
            Assert.IsTrue(p is NavPosEcef);

            Assert.IsTrue(Parser.TryParse(P.NavSol, out p));
            Assert.IsTrue(p is NavSol);

        }

        [Test]
        public void AddParser()
        {
            Yubeshi.UnknownPacket p;

            Assert.IsTrue(Parser.TryParse(P.UserDefined, out p));
            Assert.IsTrue(p is Unknown);

            Parser.AddParser((Packet.MessageID)0xFFFF, MyPacket.TryParse);

            Assert.IsTrue(Parser.TryParse(P.UserDefined, out p));
            Assert.IsTrue(p is MyPacket);
            Assert.AreEqual(0x04030201, (p as MyPacket).Content);

            Parser.RemoveParser((Packet.MessageID)0xFFFF);

            Assert.IsTrue(Parser.TryParse(P.UserDefined, out p));
            Assert.IsTrue(p is Unknown);
        }
    }
}
