﻿
using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi
{
    public class OctetString
    {
        #region fields
        byte[] buffer;
        #endregion

        #region constructors
        public OctetString()
        {
            buffer = new byte[0];
        }

        public OctetString(int length)
        {
            buffer = new byte[length];
        }

        public OctetString(byte[] bytes)
        { 
            buffer = bytes.Clone() as byte[];
        }
        #endregion

        #region operators
        public byte this[int index]
        {
            get
            {
                return buffer[index];
            }
            set
            {
                buffer[index] = value;
            }
        }


        public byte[] this[int index, int length]
        {
            get
            {
                return Substring(index, length);
            }
            set
            {
                Array.Copy(value, 0, buffer, index, 
                                         (length < 0) ? value.Length : length);
            }
        }

        public static OctetString operator + 
                                        (OctetString left, OctetString right)
        {
            OctetString appended = new OctetString(left.Length + right.Length);
            Array.Copy(left.buffer, appended.buffer, left.Length);
            Array.Copy(right.buffer, 0, 
                                appended.buffer, left.Length, right.Length);
            return appended;
        }

        public static OctetString operator +(OctetString left, byte[] right)
        {
            OctetString appended = new OctetString(left.Length + right.Length);
            Array.Copy(left.buffer, appended.buffer, left.Length);
            Array.Copy(right, 0, appended.buffer, left.Length, right.Length);
            return appended;
        }

        public static implicit operator byte[](OctetString octetString)
        {
            return octetString.GetBytes();
        }

        public static implicit operator OctetString(byte[] bytes)
        {
            return new OctetString(bytes);
        }

        #endregion

        #region properties
        public int Length
        {
            get
            {
                return buffer.Length;
            }
        }
        #endregion

        #region public methods
        public OctetString Substring(int start)
        {
            return Substring(start, buffer.Length - start);
        }

        public OctetString Substring(int start, int length)
        {
            OctetString sub = new OctetString(length);
            Array.Copy(buffer, start, sub.buffer, 0, length);
            return sub;
        }
        
        public byte[] GetBytes()
        {
            return buffer.Clone() as byte[];
        }

        public override string ToString()
        {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < buffer.Length; ++i)
            { 
                byte c = buffer[i];
                if (0x20 <= c && c < 0x7F)
                {
                    s.Append((char)c);
                }
                else
                {
                    s.Append("\\" + c.ToString("X2"));
                }
            }
            return s.ToString();
        }

        public static byte[] Substring(byte[] source, int start)
        {
            return Substring(source, start, source.Length - start);
        }

        public static byte[] Substring(byte[] source, int start, int length)
        {
            byte[] sub = new byte[length];
            Array.Copy(source, start, sub, 0, length);
            return sub;
        }

        public static byte[] Concat(byte[] first, byte[] second)
        {
            byte[] joined = new byte[first.Length + second.Length];
            Array.Copy(first, joined, first.Length);
            Array.Copy(second, 0, joined, first.Length, second.Length);
            return joined;
        }

        public static int IndexOf(byte[] field, byte target)
        {
            return IndexOf(field, target, 0);
        }

        public static int IndexOf(byte[] field, byte target, int startIndex)
        {
            for (int i = startIndex; i < field.Length; ++i)
            {
                if (field[i] == target)
                {
                    return i;
                }
            }
            return -1;
        }

        public static int IndexOf(byte[] field, byte[] target)
        {
            return IndexOf(field, target, 0);
        }

        public static int IndexOf(byte[] field, byte[] target, int startIndex)
        {
            for (int i = startIndex; i <= field.Length - target.Length; ++i)
            {
                int j;
                for (j = 0; j < target.Length; ++j)
                {
                    if (field[i + j] != target[j])
                    {
                        break;
                    }
                }
                if (j == target.Length)
                {
                    return i;
                }
            }
            return -1;
        }

        #endregion
    }
}
