﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi
{
    public class UnknownPacket
    {
        #region constructors

        public UnknownPacket()
        { 
        }

        public UnknownPacket(byte[] sentence, int length)
        {
            Raw = new byte[length];
            Array.Copy(sentence, Raw, Raw.Length);
        }

        #endregion

        #region properties

        public byte[] Raw
        {
            get;
            protected set;
        }

        #endregion

        #region public methods

        public override string ToString()
        {
            StringBuilder builder = new StringBuilder(Raw.Length);
            for (int i = 0; i < Raw.Length; ++i)
            {
                byte c = Raw[i];
                if (c < 32 || c > 127)
                { 
                    builder.Append(@"\x" + c.ToString("X2"));
                }
                else
                {
                    builder.Append(Char.ConvertFromUtf32(c));
                }
            }
            return builder.ToString();
        }
        #endregion
    }
}
