﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using Yubeshi;
using C = YubeshiTest.SampleCoordinates;

namespace YubeshiTest
{
    class EcefCoordinateTest
    {

        [Test]
        public void ToGeodeticCoordinate()
        {
            GeodeticCoordinate geo = C.SkytreeTop;
            EcefCoordinate ecef = new EcefCoordinate(-3961187.702,
                                                        3346179.551,
                                                        3702497.996);

            GeodeticCoordinate converted = ecef.ToGeodeticCoordinate();

            Assert.AreEqual(geo.Latitude, converted.Latitude, 1e-6);
            Assert.AreEqual(geo.Longitude, converted.Longitude, 1e-6);
            Assert.AreEqual(geo.Altitude, converted.Altitude, 2e-4);

            // North Pole
            geo = new GeodeticCoordinate(90.0, 0.0, 
                                new Height(0, Height.Base.Wgs84Ellipsoid));
            ecef = geo.ToEcefCoordinate();
            ecef = new EcefCoordinate(0, 0, Constants.Wgs84.SemiMajorAxisB);

            converted = ecef.ToGeodeticCoordinate();

            Assert.AreEqual(geo.Latitude, converted.Latitude, 1e-6);
            Assert.AreEqual(geo.Longitude, converted.Longitude, 1e-6);
            Assert.AreEqual(geo.Altitude, converted.Altitude, 2e-4);

        }
    }
}
