﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using Yubeshi;

namespace YubeshiTest
{
    class GeodeticCoordinateTest
    {
        [Test]
        public void ToEcefCoordinate()
        {
            GeodeticCoordinate geo =
                new GeodeticCoordinate(38.13579617, 140.91581617, 41.940);
            EcefCoordinate ecef = new EcefCoordinate(-3899086.094,
                                                        3166914.545,
                                                        3917336.601);

            EcefCoordinate converted = geo.ToEcefCoordinate();

            Assert.AreEqual(ecef.X, converted.X, 1e-3);
            Assert.AreEqual(ecef.Y, converted.Y, 1e-3);
            Assert.AreEqual(ecef.Z, converted.Z, 1e-3);

        }
    }
}
