﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using Yubeshi;

namespace YubeshiTest
{
    [TestFixture]
    class HeightTest
    {

        [Test]
        public void FromDouble()
        {
            Height h = new Height(123.45);
            Assert.AreEqual(123.45, (double)h);
            Assert.AreEqual(Height.Base.Unknown, h.BaseLevel);
        }

        [Test]
        public void Add()
        {
            Height h = new Height(123.45, Height.Base.Wgs84Ellipsoid);
            Height ha = h + 1.0;
            ha = 2.0 + ha;
            Assert.AreEqual(126.45, (double)ha);
            Assert.AreEqual(Height.Base.Wgs84Ellipsoid, ha.BaseLevel);
        }

        [Test]
        public void Sub()
        {
            Height h1 = new Height(123.45, Height.Base.Wgs84Ellipsoid);
            Height h2 = new Height(67.89, Height.Base.Wgs84Ellipsoid);

            double hs = h1 - h2;
            Assert.AreEqual(55.56, (double)hs);
        }

        [Test]
        [ExpectedException(typeof(InvalidOperationException))]
        public void InvalidSub()
        {
            Height h1 = new Height(123.45, Height.Base.Wgs84Ellipsoid);
            Height h2 = new Height(67.89, Height.Base.Geoid);
            double hs = h1 - h2;
        }

        [Test]
        public void IsAltitude()
        {
            Assert.True(new Height(0, Height.Base.Geoid).IsAltitude);
            Assert.True(new Height(1, Height.Base.MeanSeaLevel).IsAltitude);
            Assert.False(new Height(2, Height.Base.Wgs84Ellipsoid).IsAltitude);
        }
    }
}
