﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using Yubeshi;
using Yubeshi.Japan;
using C = YubeshiTest.SampleCoordinates;

namespace YubeshiTest.JapanTest
{
    [TestFixture]
    class JpcTest
    {

        [Test]
        public void LlhToJpc9()
        {
            Jpc jpc = new Jpc(C.SkytreeTop, Jpc.System.IX);
            Assert.AreEqual(-32158.459, jpc.X, 1e-3);
            Assert.AreEqual(-2035.907, jpc.Y, 1e-3);
        }

        [Test]
        public void GetLengthOfMeridianArc()
        {
            Assert.AreEqual(0.0, Jpc.GetLengthOfMeridianArc(0.0));
            Assert.AreEqual(4984944.4, Jpc.GetLengthOfMeridianArc(45.0), 0.1);
            Assert.AreEqual(10001965.7, Jpc.GetLengthOfMeridianArc(90.0), 0.1);
        }

        [Test]
        public void GetSystemWithNearestOriginTo()
        {
            Jpc.System s = Jpc.GetSystemWithNearestOriginTo(C.SkytreeTop);
            Assert.AreEqual(Jpc.System.IX, s);
        }
    }
}
