﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace YubeshiTest.UbxTest
{
    public class SamplePackets
    {
        public static readonly byte[] Dummy;
        public static readonly byte[] UserDefined;

        public static readonly byte[] InfDebug;
        public static readonly byte[] InfError;
        public static readonly byte[] InfNotice;
        public static readonly byte[] InfTest;
        public static readonly byte[] InfWarning;

        public static readonly byte[] NavClock;
        public static readonly byte[] NavDop;
        public static readonly byte[] NavPosEcef;
        public static readonly byte[] NavPosLlh;
        public static readonly byte[] NavSol;


        public static readonly byte[] ValidUnknown;


        static SamplePackets()
        {
            Dummy = new byte[] {
                0xB5, 0x63, 0xFF, 0xFF, 0x04, 0x00,
                0x01, 0x02, 0x03, 0x04, 
                0xFF, 0xFF
            };

            UserDefined = new byte[] {
                0xB5, 0x62, 0xFF, 0xFF, 0x04, 0x00,
                0x01, 0x02, 0x03, 0x04, 
                0xFF, 0xFF
            };

            #region Inf

            InfDebug = new byte[]{
                0xB5, 0x62, 0x04, 0x04, 0x08, 0x00,
                (byte)'!', 0,
                (byte)'D', (byte)'e', (byte)'b', (byte)'u', 
                (byte)'g', (byte)'.',
                0xFF, 0xFF
            };

            InfError = new byte[]{
                0xB5, 0x62, 0x04, 0x00, 0x08, 0x00,
                (byte)'!', 0,
                (byte)'E', (byte)'r', (byte)'r', (byte)'o',
                (byte)'r', (byte)'.',
                0xFF, 0xFF
            };

            InfNotice = new byte[]{
                0xB5, 0x62, 0x04, 0x02, 0x09, 0x00,
                (byte)'!', 0,
                (byte)'N', (byte)'o', (byte)'t', (byte)'i', 
                (byte)'c', (byte)'e', (byte)'.',
                0xFF, 0xFF
            };

            InfTest = new byte[]{
                0xB5, 0x62, 0x04, 0x03, 0x07, 0x00,
                (byte)'!', 0, 
                (byte)'T', (byte)'e', (byte)'s', (byte)'t', 
                (byte)'.',
                0xFF, 0xFF
            };

            InfWarning = new byte[]{
                0xB5, 0x62, 0x04, 0x01, 0x0A, 0x00,
                (byte)'!', 0,
                (byte)'W', (byte)'a', (byte)'r', (byte)'n', 
                (byte)'i', (byte)'n', (byte)'g', (byte)'.',
                0xFF, 0xFF
            };
            #endregion

            #region Nav
            NavClock = new byte[]{
                0xB5, 0x62, 0x01, 0x22, 0x14, 0x00, 
                0xE5, 0x16, 0x3F, 0x0A, // tow
                0x3C, 0xDA, 0x06, 0x00, 
                0x48, 0x01, 0x00, 0x00, 
                0x4E, 0x00, 0x00, 0x00, 
                0x34, 0x12, 0x00, 0x00, 
                0xFF, 0xFF
            };

            NavDop = new byte[]{
                0xB5, 0x62, 0x01, 0x04, 0x12, 0x00, 
                0xE5, 0x16, 0x3F, 0x0A, // tow
                0x00, 0x00, // geometric
                0x00, 0x00, // position
                0x00, 0x00, // time
                0x00, 0x00, // vertical
                0x00, 0x00, // horizonal
                0x00, 0x00, // northing
                0x00, 0x00, // easting
                0xFF, 0xFF
            };

            NavPosEcef = new byte[]{
                0xB5, 0x62, 0x01, 0x01, 0x14, 0x00,
                0xE5, 0x16, 0x3F, 0x0A, // tow
                0x8B, 0xB7, 0x63, 0xE8, // x
                0x8F, 0xE0, 0xF1, 0x13, // y
                0x10, 0x8C, 0x11, 0x16, // z
                0x6D, 0x14, 0x00, 0x00, // acc
                0xFF, 0xFF
            };

            NavPosLlh = new byte[]{
                0xB5, 0x62, 0x01, 0x02, 0x1C, 0x00,
                0xE5, 0x16, 0x3F, 0x0A, // tow
                0x36, 0x6C, 0x55, 0x53, // lon
                0x24, 0xEC, 0x48, 0x15, // lat 
                0x27, 0x52, 0x0A, 0x00, // height
                0x00, 0xC4, 0x09, 0x00, // hMSL 
                0x6D, 0x14, 0x00, 0x00, // hAcc
                0x6D, 0x14, 0x00, 0x00, // vAcc
                0xFF, 0xFF
            };

            NavSol = new byte[]{
                0xB5, 0x62, 0x01, 0x06, 0x34, 0x00,
                0xE5, 0x16, 0x3F, 0x0A, // tow
                0x39, 0x30, 0x00, 0x00, // ftow
                0x4E, 0x06,
                0x02,
                0x5D,
                0x8B, 0xB7, 0x63, 0xE8, // x
                0x8F, 0xE0, 0xF1, 0x13, // y
                0x10, 0x8C, 0x11, 0x16, // z
                0x6D, 0x14, 0x00, 0x00, // acc
                0xF6, 0xFF, 0xFF, 0xFF, // vx
                0xE5, 0xFF, 0xFF, 0xFF, // vy
                0x0E, 0x00, 0x00, 0x00, // vz
                0x29, 0x01, 0x00, 0x00,
                0xF1, 0x00, 0x02, 0x03,
                0x1B, 0x1E, 0x01, 0x00,
                0xFF, 0xFF
            };
            #endregion

            ValidUnknown = new byte[]{
                0xB5, 0x62, 0x03, 0x0C, 0x22, 0x00,
                0x00, 0x00, 0x00, 0x00, 
                0x00, 0x00, 0x00, 0x00, 
                0x00, 0x00, 0x00, 0x00, 
                0x00, 0x00, 0x00, 0x00, 
                0x00, 0x00, 0x00, 0x00, 
                0x00, 0x00, 0x00, 0x00, 
                0x00, 0x00, 0x00, 0x00, 
                0x00, 0x00, 0x00, 0x00, 
                0x00, 0x00,
                0xFF, 0xFF
            };
        }
    }
}
