﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using Yubeshi;

namespace YubeshiTest
{
    [TestFixture]
    class UnknownPacketTest
    {
        [Test]
        public new void ToString()
        {
            byte[] sentence = new byte[]{
                0x24, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 
                0x20, 0x61, 0x6e, 0x20, 0x75, 0x6e, 0x6b, 0x6e, 
                0x6f, 0x77, 0x6e, 0x20, 0x70, 0x61, 0x63, 0x6b, 
                0x65, 0x74, 0xff, 0x0d, 0x0a
            };
            UnknownPacket p = new UnknownPacket(sentence, sentence.Length);
            Assert.AreEqual(@"$This is an unknown packet\xFF\x0D\x0A", 
                                                                p.ToString());
        }
    }
}
