
package com.yx.mvc.command;

import com.yx.util.TALogger;

/**
 * @Title TACommandThread
 * @package com.yx.mvc.command
 * @Description TACommandThread是一个专门执行command的线程
 * @author YXDroid
 * @date 2014-1-16 下午 16:53
 * @version V1.0
 */
public class TACommandThread implements Runnable
{
	private int threadId;
	private Thread thread = null;
	private boolean running = false;
	private boolean stop = false;

	public TACommandThread(int threadId)
	{
		TALogger.i(TACommandThread.this, "CommandThread::ctor");
		this.threadId = threadId;
		thread = new Thread(this);
	}

	public void run()
	{
		TALogger.i(TACommandThread.this, "CommandThread::run-enter");
		while (!stop)
		{
			TALogger.i(TACommandThread.this, "CommandThread::get-next-command");
			TAICommand cmd = TACommandQueueManager.getInstance()
					.getNextCommand();
			TALogger.i(TACommandThread.this, "CommandThread::to-execute");
			cmd.execute();
			TALogger.i(TACommandThread.this, "CommandThread::executed");
		}
		TALogger.i(TACommandThread.this, "CommandThread::run-exit");
	}

	public void start()
	{
		thread.start();
		running = true;
	}

	public void stop()
	{
		stop = true;
		running = false;
	}

	public boolean isRunning()
	{
		return running;
	}

	public int getThreadId()
	{
		return threadId;
	}
}
