
package com.yx.util.db.util.sql;

import java.lang.reflect.Field;

import com.yx.exception.TADBException;
import com.yx.util.db.entity.TAArrayList;
import com.yx.util.db.util.TADBUtils;

/**
 * @Title TASqlBuilder
 * @Package com.yx.util.db.util.sql
 * @Description 删除sql语句构建器类
 * @author YXDroid
 * @date 2014-1-20
 * @version V1.0
 */
public class TADeleteSqlBuilder extends TASqlBuilder
{
	@Override
	public String buildSql() throws TADBException, IllegalArgumentException,
			IllegalAccessException
	{
		// TODO Auto-generated method stub
		StringBuilder stringBuilder = new StringBuilder(256);
		stringBuilder.append("DELETE FROM ");
		stringBuilder.append(tableName);
		if (entity == null)
		{
			stringBuilder.append(buildConditionString());
		} else
		{
			stringBuilder.append(buildWhere(buildWhere(this.entity)));
		}

		return stringBuilder.toString();
	}

	/**
	 * 创建Where语句
	 * 
	 * @param entity
	 * @return
	 * @throws IllegalArgumentException
	 * @throws IllegalAccessException
	 * @throws TADBException
	 */
	public TAArrayList buildWhere(Object entity)
			throws IllegalArgumentException, IllegalAccessException,
			TADBException
	{
		Class<?> clazz = entity.getClass();
		TAArrayList whereArrayList = new TAArrayList();
		Field[] fields = clazz.getDeclaredFields();
		for (Field field : fields)
		{
			field.setAccessible(true);
			if (!TADBUtils.isTransient(field))
			{
				if (TADBUtils.isBaseDateType(field))
				{
					// 如果ID不是自动增加的
					if (!TADBUtils.isAutoIncrement(field))
					{
						String columnName = TADBUtils.getColumnByField(field);
						if (null != field.get(entity)
								&& field.get(entity).toString().length() > 0)
						{
							whereArrayList.add(
									(columnName != null && !columnName
											.equals("")) ? columnName : field
											.getName(), field.get(entity)
											.toString());
						}
					}
				}
			}
		}
		if (whereArrayList.isEmpty())
		{
			throw new TADBException("不能创建Where条件，语句");
		}
		return whereArrayList;
	}
}
