#include "r_defs.h"
#include "r_state.h"
#include "v_video.h"
#include "thingdef.h"
#include "p_lnspec.h"
#include "gl/textures/gl_texture.h"
#include "gl/textures/gl_material.h"

#ifdef NO_GL
// [BB] Having to declare dummy versions of all the dynamic lights is pretty awful...
class ADynamicLight : public AActor
{
	DECLARE_CLASS (ADynamicLight, AActor)
};

class AVavoomLight : public ADynamicLight
{
   DECLARE_CLASS (AVavoomLight, ADynamicLight)
};

class AVavoomLightWhite : public AVavoomLight
{
   DECLARE_CLASS (AVavoomLightWhite, AVavoomLight)
};

class AVavoomLightColor : public AVavoomLight
{
   DECLARE_CLASS (AVavoomLightColor, AVavoomLight)
};

IMPLEMENT_CLASS (ADynamicLight, false, false)
IMPLEMENT_CLASS (AVavoomLight, false, false)
IMPLEMENT_CLASS (AVavoomLightWhite, false, false)
IMPLEMENT_CLASS (AVavoomLightColor, false, false)

DEFINE_CLASS_PROPERTY(type, S, DynamicLight)
{
	PROP_STRING_PARM(str, 0);
}

CVAR (Float, vid_brightness, 0.f, CVAR_ARCHIVE|CVAR_GLOBALCONFIG)
CVAR (Float, vid_contrast, 1.f, CVAR_ARCHIVE|CVAR_GLOBALCONFIG)

void gl_CleanLevelData()
{
}

void gl_PreprocessLevel()
{
}

void gl_ParseDefs()
{
}

void gl_InitModels()
{
}

void StartGLMenu (void)
{
}

void FGLTexture::Clean(bool)
{
}

FTexture::MiscGLInfo::MiscGLInfo() throw ()
{
}

FTexture::MiscGLInfo::~MiscGLInfo()
{
}

void AddStateLight(FState *, const char *)
{
}

void LS_SetGlobalFogParameter(line_t*, AActor*, bool, int, int, int, int, int)
{
}

size_t AActor::PropagateMark()
{
	return Super::PropagateMark();
}

#endif
