
CREATE TABLE user_auth_table (
	aastat_in     int not null,
	cnum_in       int not null,
	eoa1_in       int not null,
	eoa2_in       int not null,
	loginstat_in  int,
	soip_inet     inet,
	starttime_lin bigint,
	stoptime_lin  bigint,
	lltime_lin    bigint,
	lotime_lin    bigint,
	detime_lin    bigint,
	fmaddr_ch256  varchar(256) not null,
	uname_ch256   varchar(256) not null,
	pass_ch256    varchar(256) not null,
	sesid_ch256   varchar(256),
	makeys_ch256  varchar(256),
	uukey_in      serial
);

COMMENT ON TABLE user_auth_table IS 'user authentication table.';
COMMENT ON COLUMN user_auth_table.aastat_in IS 'accunt authentication status.';
COMMENT ON COLUMN user_auth_table.cnum_in IS 'class number.';
COMMENT ON COLUMN user_auth_table.eoa1_in IS 'element of the associative(1).';
COMMENT ON COLUMN user_auth_table.eoa2_in IS 'element of the associative(２).';
COMMENT ON COLUMN user_auth_table.loginstat_in IS 'Login status.';
COMMENT ON COLUMN user_auth_table.soip_inet IS 'source ip address.';
COMMENT ON COLUMN user_auth_table.starttime_lin IS 'services start time.';
COMMENT ON COLUMN user_auth_table.stoptime_lin IS 'services stop time.';
COMMENT ON COLUMN user_auth_table.lltime_lin IS 'last login time.';
COMMENT ON COLUMN user_auth_table.lotime_lin IS 'last logout time.';
COMMENT ON COLUMN user_auth_table.detime_lin IS 'deadline time.';
COMMENT ON COLUMN user_auth_table.fmaddr_ch256 IS 'first mail address.';
COMMENT ON COLUMN user_auth_table.uname_ch256 IS 'user name.';
COMMENT ON COLUMN user_auth_table.pass_ch256 IS 'password.';
COMMENT ON COLUMN user_auth_table.sesid_ch256 IS 'session id.';
COMMENT ON COLUMN user_auth_table.makeys_ch256 IS 'mail authentication key.';
COMMENT ON COLUMN user_auth_table.uukey_in IS 'user unique key.';

