// convert.c
// masashi shimakura 20140223

#include <stdio.h>
#include <string.h>
#include <iconv.h>
#include <errno.h>

#include "libms.h"


int convert(const char *input_code, const char *output_code, const char *input_text, char *output_buf, size_t output_bufsize)
{
iconv_t iconv_fd;
size_t input_len, output_len;
size_t iconv_ret;

iconv_fd = iconv_open(output_code, input_code);
if(iconv_fd == (iconv_t)-1){
  fprintf(stderr,"iconv not open =  %s <%d>\n", strerror(errno), errno);
  iconv_close(iconv_fd);
  return -1;
  }

input_len = strlen(input_text);
output_len = output_bufsize - 1;

iconv_ret = iconv(iconv_fd, &input_text, &input_len, &output_buf, &output_len);

#ifdef ICONV_BUG
printf("iconv stat =  <ret %d> <max size %d>\n", iconv_ret, output_bufsize);
#endif

if(iconv_ret == -1){
  fprintf(stderr, "iconv err =  %s <%d>\n", strerror(errno), errno);
  iconv_close(iconv_fd);
  return -1;
  }

iconv_close(iconv_fd);
return 0;
}



