
CREATE TABLE monitor_plan_table (
	uukey_in       int not null,
	mpsnumber_in   int not null,
	moproto_in     int not null,
	serverkey_in   int not null,
	modport_in     int,
	mailprno_in    int not null,
	mailreno_in    int not null,
	invtime_in     int,
	sosstat_in     int,
	starttime_lin  bigint,
	stoptime_lin   bigint,
	modhost_ch1024 varchar(1024),
	mpukey_in      serial
);

COMMENT ON TABLE monitor_plan_table IS 'Table from which the monitoring.';
COMMENT ON COLUMN monitor_plan_table.uukey_in IS 'user unique key.';
COMMENT ON COLUMN monitor_plan_table.mpsnumber_in IS 'monitor plan serial number.';
COMMENT ON COLUMN monitor_plan_table.moproto_in IS 'monitoring protocol.';
COMMENT ON COLUMN monitor_plan_table.serverkey_in IS 'monitoring server ID.';
COMMENT ON COLUMN monitor_plan_table.modport_in IS 'monitoring destination port number.';
COMMENT ON COLUMN monitor_plan_table.mailprno_in IS 'For the problem notification.';
COMMENT ON COLUMN monitor_plan_table.mailreno_in IS 'For the restoration notification.';
COMMENT ON COLUMN monitor_plan_table.invtime_in IS 'interval time.';
COMMENT ON COLUMN monitor_plan_table.sosstat_in IS 'start or stop status.';
COMMENT ON COLUMN monitor_plan_table.starttime_lin IS 'start time.';
COMMENT ON COLUMN monitor_plan_table.stoptime_lin IS 'stop time.';
COMMENT ON COLUMN monitor_plan_table.modhost_ch1024 IS 'monitoring destination host.';
COMMENT ON COLUMN monitor_plan_table.mpukey_in IS 'monitor plan unique key.';

