package jp.coocan.la.aide.android.snapcard;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.Style;
import android.view.View;


/**
 * SnapInアニメーション用の表示レイヤ
 * @author aide
 *
 */
public class SnapinView extends View {

	private Paint  paint;
	private Bitmap cardBitmap = null;


	public SnapinView(Context context) {
		super(context);

		paint = new Paint();
		paint.setAntiAlias( true );
		paint.setColor( Color.BLACK );
		paint.setStyle( Style.FILL );

		setVisibility( INVISIBLE );
	}

	public void setCardBitmap(Bitmap cardBitmap){
		this.cardBitmap = cardBitmap;
		invalidate();
	}

	@Override
	protected void onDraw(Canvas canvas) {
		canvas.drawColor(Color.BLACK);
		float x = (canvas.getWidth()  - cardBitmap.getWidth() ) / 2;
		float y = (canvas.getHeight() - cardBitmap.getHeight()) / 2;
		canvas.drawBitmap( cardBitmap, x, y, paint );
	}

}
