package jp.coocan.la.aide.android.snapcard;


/**
 * 定数定義
 * @author aide
 *
 */
public class AppConst {

	/** Preferenceキー */
	public class Pref {
		public static final String CARDIMAGE_URI = "CardImageUri";              //名刺画像のURI
	}

	/** IntentリクエストID */
	public class IntentRequest {
		public static final int GALLERY = 1;                                    //画像選択Intent
	}

	/** デバイス */
	public class Device {
		public static final float ACCELEROMETER_SENSITIVITY = 2.0f;
	}

	/** スケール情報 */
	public class Scale {
		public static final float  CARD_INCH_X = 2.17f;                         //名刺の実サイズ：幅
		public static final float  CARD_INCH_Y = 3.56f;                         //名刺の実サイズ：高さ
		//		public static final float  CARD_XYAVG  = CARD_INCH_Y / CARD_INCH_X;     //名刺の実サイズ：幅／高さの比
	}

	/** 表示している名刺の状態 */
	public class CardStatus {
		public static final int    TAPABLE   = 0;                               //タップ＆ドラッグ可能
		public static final int    SNAPOUT   = 1;                               //SnapOut実行中
		public static final int    INVISIBLE = 2;                               //SnapOut後で非表示
		public static final int    SNAPIN    = 3;                               //SnapIn実行中
	}

	/** SnapOut用 */
	public class SnapOut {
		public static final float  STARTAVG = 0.15f;                            //SnapOut開始移動距離(%)
		public static final float  STEPAVG  = 0.20f;                            //フレームあたりの移動距離(%)
		public static final int    TO_RIGHT = 0;                                //右へSnapOut
		public static final int    TO_LEFT  = 1;                                //左へSnapOut
		public static final int    TO_UP    = 2;                                //上へSnapOut
		public static final int    TO_DOWN  = 3;                                //下へSnapOut
	}

}
