#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "thcalcmd5.h"

#include <QMainWindow>

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
    
public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    QStringList args;

private slots:
    void showEvent(QShowEvent *event);
    void dragEnterEvent(QDragEnterEvent *event);
    void dropEvent(QDropEvent *event);

    void slot_calc_end(QString);
    void slot_calc_progress(int);

    void on_actionExit_triggered();

    void on_actionAbout_triggered();

    void on_actionAbout_Qt_triggered();

    void on_toolButton_Select_clicked();

    void on_lineEdit_FilePath_textChanged(const QString &arg1);

    void on_pushButton_Start_clicked();

    void on_pushButton_Abort_clicked();

    void on_lineEdit_VerifyMD5_textChanged();

private:
    Ui::MainWindow *ui;

    bool firstShow;

    ThCalcMD5 *thcalcmd5;
};

#endif // MAINWINDOW_H
